/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.StringMatcher;

public class DynamicMemberReferenceInitializer
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    private static final boolean DEBUG = false;
    private static final int CLASS_INDEX = 0x40000003;
    private static final int MEMBER_NAME_INDEX = 0x40000004;
    private static final int MEMBER_TYPE_INDEX = 0x40000005;
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter notePrinter;
    private final StringMatcher noteFieldExceptionMatcher;
    private final StringMatcher noteMethodExceptionMatcher;
    private final InstructionSequenceMatcher knownItegerUpdaterMatcher;
    private final InstructionSequenceMatcher knownLongUpdaterMatcher;
    private final InstructionSequenceMatcher knownReferenceUpdaterMatcher;
    private final InstructionSequenceMatcher unknownIntegerUpdaterMatcher;
    private final InstructionSequenceMatcher unknownLongUpdaterMatcher;
    private final InstructionSequenceMatcher unknownReferenceUpdaterMatcher;
    private final MyDynamicMemberFinder dynamicMemberFinder = new MyDynamicMemberFinder();
    private final MemberFinder memberFinder = new MemberFinder(true);
    private final MemberFinder declaredMemberFinder = new MemberFinder(false);
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
    private Clazz referencedClass;

    public DynamicMemberReferenceInitializer(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter notePrinter, StringMatcher noteFieldExceptionMatcher, StringMatcher noteMethodExceptionMatcher) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.notePrinter = notePrinter;
        this.noteFieldExceptionMatcher = noteFieldExceptionMatcher;
        this.noteMethodExceptionMatcher = noteMethodExceptionMatcher;
        InstructionSequenceBuilder builder = new InstructionSequenceBuilder(programClassPool, libraryClassPool);
        Instruction[] knownItegerUpdaterInstructions = builder.ldc_(0x40000003).ldc_(0x40000004).invokestatic("java/util/concurrent/atomic/AtomicIntegerFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;").instructions();
        Instruction[] knownLongUpdaterInstructions = builder.ldc_(0x40000003).ldc_(0x40000004).invokestatic("java/util/concurrent/atomic/AtomicLongFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicLongFieldUpdater;").instructions();
        Instruction[] knownReferenceUpdaterInstructions = builder.ldc_(0x40000003).ldc_(0x40000005).ldc_(0x40000004).invokestatic("java/util/concurrent/atomic/AtomicReferenceFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;").instructions();
        Instruction[] unknownIntegerUpdaterInstructions = builder.ldc_(0x40000004).invokestatic("java/util/concurrent/atomic/AtomicIntegerFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;").instructions();
        Instruction[] unknownLongUpdaterInstructions = builder.ldc_(0x40000004).invokestatic("java/util/concurrent/atomic/AtomicLongFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicLongFieldUpdater;").instructions();
        Instruction[] unknownReferenceUpdaterInstructions = builder.ldc_(0x40000004).invokestatic("java/util/concurrent/atomic/AtomicReferenceFieldUpdater", "newUpdater", "(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;").instructions();
        Constant[] constants = builder.constants();
        this.knownItegerUpdaterMatcher = new InstructionSequenceMatcher(constants, knownItegerUpdaterInstructions);
        this.knownLongUpdaterMatcher = new InstructionSequenceMatcher(constants, knownLongUpdaterInstructions);
        this.knownReferenceUpdaterMatcher = new InstructionSequenceMatcher(constants, knownReferenceUpdaterInstructions);
        this.unknownIntegerUpdaterMatcher = new InstructionSequenceMatcher(constants, unknownIntegerUpdaterInstructions);
        this.unknownLongUpdaterMatcher = new InstructionSequenceMatcher(constants, unknownLongUpdaterInstructions);
        this.unknownReferenceUpdaterMatcher = new InstructionSequenceMatcher(constants, unknownReferenceUpdaterInstructions);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        instruction.accept(clazz, method, codeAttribute, offset, this.dynamicMemberFinder);
        this.matchGetMember(clazz, method, codeAttribute, offset, instruction, this.knownItegerUpdaterMatcher, this.unknownIntegerUpdaterMatcher, true, false, false, "I");
        this.matchGetMember(clazz, method, codeAttribute, offset, instruction, this.knownLongUpdaterMatcher, this.unknownLongUpdaterMatcher, true, false, false, "J");
        this.matchGetMember(clazz, method, codeAttribute, offset, instruction, this.knownReferenceUpdaterMatcher, this.unknownReferenceUpdaterMatcher, true, false, false, null);
    }

    private void matchGetMember(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction, InstructionSequenceMatcher constantSequenceMatcher, InstructionSequenceMatcher variableSequenceMatcher, boolean isField, boolean isConstructor, boolean isDeclared, String memberDescriptor) {
        if (constantSequenceMatcher != null) {
            instruction.accept(clazz, method, codeAttribute, offset, constantSequenceMatcher);
            if (constantSequenceMatcher.isMatching()) {
                int memberNameInstructionOffset = constantSequenceMatcher.matchedInstructionOffset(constantSequenceMatcher.instructionCount() - 2);
                int classIndex = constantSequenceMatcher.matchedConstantIndex(0x40000003);
                clazz.constantPoolEntryAccept(classIndex, this);
                if (this.referencedClass != null) {
                    int typeClassIndex = constantSequenceMatcher.matchedConstantIndex(0x40000005);
                    if (typeClassIndex > 0) {
                        memberDescriptor = ClassUtil.internalTypeFromClassName(clazz.getClassName(typeClassIndex));
                    }
                    int memberNameIndex = constantSequenceMatcher.matchedConstantIndex(0x40000004);
                    String memberName = clazz.getStringString(memberNameIndex);
                    this.initializeDynamicMemberReference(clazz, memberNameInstructionOffset, this.referencedClass, memberName, memberDescriptor, isField, isConstructor, isDeclared);
                }
                variableSequenceMatcher.reset();
            }
        }
        instruction.accept(clazz, method, codeAttribute, offset, variableSequenceMatcher);
        if (variableSequenceMatcher.isMatching()) {
            int memberNameIndex = variableSequenceMatcher.matchedConstantIndex(0x40000004);
            String memberName = clazz.getStringString(memberNameIndex);
            this.printDynamicMemberAccessNote(clazz, memberName, memberDescriptor, isField, isConstructor, isDeclared);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.referencedClass = ClassUtil.isInternalArrayType(classConstant.getName(clazz)) ? null : classConstant.referencedClass;
    }

    private void initializeDynamicMemberReference(Clazz clazz, int memberNameInstructionOffset, Clazz referencedClass, String memberName, String memberDescriptor, boolean isField, boolean isConstructor, boolean isDeclared) {
        MemberFinder referencedMemberFinder = isDeclared ? this.declaredMemberFinder : this.memberFinder;
        Member referencedMember = referencedMemberFinder.findMember(referencedClass, memberName, memberDescriptor, isField);
        if (referencedMember != null) {
            if (!isDeclared) {
                referencedClass = referencedMemberFinder.correspondingClass();
            }
            int stringConstantIndex = new ConstantPoolEditor((ProgramClass)clazz).addStringConstant(memberName, referencedClass, referencedMember);
            this.codeAttributeEditor.replaceInstruction(memberNameInstructionOffset, new ConstantInstruction(18, stringConstantIndex));
        }
    }

    private void printDynamicConstructorAccessNote(Clazz clazz, Clazz referencedClass, String memberDescriptor, boolean isDeclared) {
        if (this.notePrinter != null && this.notePrinter.accepts(clazz.getName()) && (this.noteMethodExceptionMatcher == null || !this.noteMethodExceptionMatcher.matches("<init>"))) {
            this.notePrinter.print(clazz.getName(), "Note: " + ClassUtil.externalClassName(clazz.getName()) + " retrieves a " + (isDeclared ? "declared " : "") + "constructor '" + "<init>" + '(' + ClassUtil.externalMethodArguments(memberDescriptor) + ')' + "' dynamically");
            AllMethodVisitor classVisitor = new AllMethodVisitor(new MemberNameFilter("<init>", (MemberVisitor)new MemberDescriptorFilter(memberDescriptor, (MemberVisitor)this)));
            if (referencedClass != null) {
                referencedClass.hierarchyAccept(true, !isDeclared, false, false, classVisitor);
            } else {
                this.programClassPool.classesAcceptAlphabetically(classVisitor);
                this.libraryClassPool.classesAcceptAlphabetically(classVisitor);
            }
        }
    }

    private void printDynamicMemberAccessNote(Clazz clazz, String memberName, String memberDescriptor, boolean isField, boolean isConstructor, boolean isDeclared) {
        if (this.notePrinter != null && this.notePrinter.accepts(clazz.getName())) {
            StringMatcher noteExceptionMatcher;
            StringMatcher stringMatcher = noteExceptionMatcher = isField ? this.noteFieldExceptionMatcher : this.noteMethodExceptionMatcher;
            if (noteExceptionMatcher == null || !noteExceptionMatcher.matches(memberName)) {
                String externalMemberDescription = memberName;
                if (!isField) {
                    externalMemberDescription = externalMemberDescription + '(' + ClassUtil.externalMethodArguments(memberDescriptor) + ')';
                }
                this.notePrinter.print(clazz.getName(), "Note: " + ClassUtil.externalClassName(clazz.getName()) + " accesses a " + (isDeclared ? "declared " : "") + (isField ? "field" : (isConstructor ? "constructor" : "method")) + " '" + externalMemberDescription + "' dynamically");
                ClassVisitor classVisitor = isField ? (memberDescriptor == null ? new AllFieldVisitor(new MemberNameFilter(memberName, (MemberVisitor)this)) : new AllFieldVisitor(new MemberNameFilter(memberName, (MemberVisitor)new MemberDescriptorFilter(memberDescriptor, (MemberVisitor)this)))) : new AllMethodVisitor(new MemberNameFilter(memberName, (MemberVisitor)new MemberDescriptorFilter(memberDescriptor, (MemberVisitor)this)));
                this.programClassPool.classesAcceptAlphabetically(classVisitor);
                this.libraryClassPool.classesAcceptAlphabetically(classVisitor);
            }
        }
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.notePrinter.accepts(programClass.getName())) {
            System.out.println("      Maybe this is program field '" + ClassUtil.externalFullClassDescription(0, programClass.getName()) + " { " + ClassUtil.externalFullFieldDescription(0, programField.getName(programClass), programField.getDescriptor(programClass)) + "; }'");
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.notePrinter.accepts(programClass.getName())) {
            System.out.println("      Maybe this is program method '" + ClassUtil.externalFullClassDescription(0, programClass.getName()) + " { " + ClassUtil.externalFullMethodDescription(programClass.getName(), 0, programMethod.getName(programClass), programMethod.getDescriptor(programClass)) + "; }'");
        }
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (this.notePrinter.accepts(libraryClass.getName())) {
            System.out.println("      Maybe this is library field '" + ClassUtil.externalFullClassDescription(0, libraryClass.getName()) + " { " + ClassUtil.externalFullFieldDescription(0, libraryField.getName(libraryClass), libraryField.getDescriptor(libraryClass)) + "; }'");
        }
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.notePrinter.accepts(libraryClass.getName())) {
            System.out.println("      Maybe this is library method '" + ClassUtil.externalFullClassDescription(0, libraryClass.getName()) + " { " + ClassUtil.externalFullMethodDescription(libraryClass.getName(), 0, libraryMethod.getName(libraryClass), libraryMethod.getDescriptor(libraryClass)) + "; }'");
        }
    }

    private class MyDynamicMemberFinder
    extends SimplifiedVisitor
    implements InstructionVisitor,
    ConstantVisitor {
        private static final int LABEL_START = 0;
        private static final int LABEL_LOAD_MEMBER_NAME = 1;
        private static final int LABEL_LOAD_CLASS_ARRAY_SIZE = 2;
        private static final int LABEL_CREATE_CLASS_ARRAY = 3;
        private static final int LABEL_DUP_CLASS_ARRAY = 4;
        private static final int LABEL_LOAD_PARAMETER_INDEX = 5;
        private static final int LABEL_LOAD_PARAMETER_TYPE = 6;
        private static final int LABEL_STORE_PARAMETER = 7;
        private static final int LABEL_GET_MEMBER = 8;
        private int label;
        private int instructionOffset;
        private int memberNameInstructionOffset;
        private Clazz referencedClass;
        private String memberName;
        private int parameterCount;
        private int parameterIndex;
        private StringBuffer parameterTypes = new StringBuffer();

        private MyDynamicMemberFinder() {
        }

        public void reset() {
            this.label = 0;
            this.referencedClass = null;
            this.memberName = null;
            this.parameterTypes.setLength(0);
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            this.reset();
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            int transition = this.label | simpleInstruction.canonicalOpcode() << 8;
            switch (transition) {
                case 768: 
                case 769: 
                case 771: 
                case 772: 
                case 774: 
                case 775: 
                case 776: {
                    this.reset();
                    this.parameterCount = simpleInstruction.constant;
                    this.label = 3;
                    break;
                }
                case 770: {
                    this.parameterCount = simpleInstruction.constant;
                    this.label = 3;
                    break;
                }
                case 258: {
                    this.parameterCount = 0;
                    this.label = 8;
                    break;
                }
                case 22788: {
                    this.label = 5;
                    break;
                }
                case 773: {
                    if (this.parameterIndex == simpleInstruction.constant) {
                        this.label = 6;
                        break;
                    }
                    this.reset();
                    this.parameterCount = simpleInstruction.constant;
                    this.label = 3;
                    break;
                }
                case 21255: {
                    this.label = ++this.parameterIndex < this.parameterCount ? 4 : 8;
                    break;
                }
                default: {
                    this.reset();
                }
            }
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            switch (constantInstruction.canonicalOpcode()) {
                case 18: {
                    this.instructionOffset = offset;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                    break;
                }
                case -78: 
                case -74: {
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                    break;
                }
                case -67: {
                    if (this.label == 3) {
                        clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                        break;
                    }
                    this.reset();
                    break;
                }
                default: {
                    this.reset();
                }
            }
        }

        public void visitAnyConstant(Clazz clazz, Constant constant) {
            this.reset();
        }

        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            switch (this.label) {
                case 0: {
                    this.referencedClass = classConstant.referencedClass;
                    this.label = 1;
                    break;
                }
                case 3: {
                    if (classConstant.getName(clazz).equals("java/lang/Class")) {
                        this.parameterIndex = 0;
                        this.label = this.parameterCount > 0 ? 4 : 8;
                        break;
                    }
                    this.referencedClass = classConstant.referencedClass;
                    this.label = 1;
                    break;
                }
                case 6: {
                    String parameterType = ClassUtil.internalTypeFromClassType(classConstant.getName(clazz));
                    this.parameterTypes.append(parameterType);
                    this.label = 7;
                    break;
                }
                default: {
                    this.referencedClass = classConstant.referencedClass;
                    this.label = 1;
                }
            }
        }

        public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
            switch (this.label) {
                case 1: {
                    break;
                }
                default: {
                    this.referencedClass = null;
                }
            }
            this.memberNameInstructionOffset = this.instructionOffset;
            this.memberName = stringConstant.getString(clazz);
            this.label = 2;
        }

        public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
            switch (this.label) {
                case 6: {
                    String className = fieldrefConstant.getClassName(clazz);
                    String fieldName = fieldrefConstant.getName(clazz);
                    String fieldType = fieldrefConstant.getType(clazz);
                    if (className.startsWith("java/lang/") && fieldName.equals("TYPE") && fieldType.equals("Ljava/lang/Class;")) {
                        char parameterType = ClassUtil.internalPrimitiveTypeFromNumericClassName(className);
                        this.parameterTypes.append(parameterType);
                        this.label = 7;
                        break;
                    }
                    this.reset();
                    break;
                }
                default: {
                    this.reset();
                }
            }
        }

        public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
            String className = methodrefConstant.getClassName(clazz);
            if (className.equals("java/lang/Class")) {
                String methodName = methodrefConstant.getName(clazz);
                String methodType = methodrefConstant.getType(clazz);
                if (this.label == 2 && methodType.equals("(Ljava/lang/String;)Ljava/lang/reflect/Field;") && this.memberName != null) {
                    if (methodName.equals("getField")) {
                        this.resolveMemberString(clazz, true, false, false);
                    } else if (methodName.equals("getDeclaredField")) {
                        this.resolveMemberString(clazz, true, false, true);
                    } else {
                        this.reset();
                    }
                } else if (this.label == 8 && methodType.equals("([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;")) {
                    if (methodName.equals("getConstructor")) {
                        this.resolveMemberString(clazz, false, true, false);
                    } else if (methodName.equals("getDeclaredConstructor")) {
                        this.resolveMemberString(clazz, false, true, true);
                    } else {
                        this.reset();
                    }
                } else if (this.label == 8 && methodType.equals("(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;") && this.memberName != null) {
                    if (methodName.equals("getMethod")) {
                        this.resolveMemberString(clazz, false, false, false);
                    } else if (methodName.equals("getDeclaredMethod")) {
                        this.resolveMemberString(clazz, false, false, true);
                    } else {
                        this.reset();
                    }
                } else {
                    this.reset();
                }
            } else {
                this.reset();
            }
        }

        private void resolveMemberString(Clazz clazz, boolean isField, boolean isConstructor, boolean isDeclared) {
            String memberDescriptor;
            String string = memberDescriptor = isField ? null : '(' + this.parameterTypes.toString() + ')' + "L***;";
            if (this.referencedClass != null) {
                if (isConstructor) {
                    DynamicMemberReferenceInitializer.this.printDynamicConstructorAccessNote(clazz, this.referencedClass, memberDescriptor, isDeclared);
                } else {
                    DynamicMemberReferenceInitializer.this.initializeDynamicMemberReference(clazz, this.memberNameInstructionOffset, this.referencedClass, this.memberName, memberDescriptor, isField, isConstructor, isDeclared);
                }
            } else {
                DynamicMemberReferenceInitializer.this.printDynamicMemberAccessNote(clazz, isConstructor ? "<init>" : this.memberName, memberDescriptor, isField, isConstructor, isDeclared);
            }
        }
    }
}

