/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.function.Supplier;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.IndexedVariableEvaluator;
import net.sf.saxon.expr.elab.LearningEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushElaborator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public final class LocalParam
extends Instruction
implements LocalBinding {
    private Operand conversionOp = null;
    private static final int REQUIRED = 4;
    private static final int TUNNEL = 8;
    private static final int IMPLICITLY_REQUIRED = 16;
    private int properties = 0;
    private Operand selectOp = null;
    private StructuredQName variableQName;
    private SequenceType requiredType;
    private int slotNumber = -999;
    private int referenceCount = 10;

    public void setSelectExpression(Expression select) {
        if (select != null) {
            if (this.selectOp == null) {
                this.selectOp = new Operand(this, select, OperandRole.NAVIGATE);
            } else {
                this.selectOp.setChildExpression(select);
            }
        } else {
            this.selectOp = null;
        }
    }

    public Expression getSelectExpression() {
        return this.selectOp == null ? null : this.selectOp.getChildExpression();
    }

    public void setRequiredType(SequenceType required) {
        this.requiredType = required;
    }

    @Override
    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredParam(boolean requiredParam) {
        this.properties = requiredParam ? (this.properties |= 4) : (this.properties &= 0xFFFFFFFB);
    }

    public void setImplicitlyRequiredParam(boolean requiredParam) {
        this.properties = requiredParam ? (this.properties |= 0x10) : (this.properties &= 0xFFFFFFEF);
    }

    public void setTunnel(boolean tunnel) {
        this.properties = tunnel ? (this.properties |= 8) : (this.properties &= 0xFFFFFFF7);
    }

    public void setReferenceCount(int refCount) {
        this.referenceCount = refCount;
    }

    @Override
    public int getCardinality() {
        return 8192;
    }

    @Override
    public boolean isAssignable() {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public int getLocalSlotNumber() {
        return this.slotNumber;
    }

    public boolean isRequiredParam() {
        return (this.properties & 4) != 0;
    }

    public boolean isImplicitlyRequiredParam() {
        return (this.properties & 0x10) != 0;
    }

    public boolean isTunnelParam() {
        return (this.properties & 8) != 0;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression e2 = super.typeCheck(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        this.checkAgainstRequiredType(visitor);
        return this;
    }

    public void computeEvaluationMode() {
    }

    @Override
    public LocalParam copy(RebindingMap rebindings) {
        LocalParam p2 = new LocalParam();
        ExpressionTool.copyLocationInfo(this, p2);
        p2.setLocation(this.getLocation());
        if (this.conversionOp != null) {
            assert (this.getConversion() != null);
            p2.setConversion(this.getConversion().copy(rebindings));
        }
        p2.properties = this.properties;
        if (this.selectOp != null) {
            assert (this.getSelectExpression() != null);
            p2.setSelectExpression(this.getSelectExpression().copy(rebindings));
        }
        p2.variableQName = this.variableQName;
        p2.requiredType = this.requiredType;
        p2.slotNumber = this.slotNumber;
        p2.referenceCount = this.referenceCount;
        return p2;
    }

    @Override
    public void addReference(VariableReference ref, boolean isLoopingReference) {
    }

    public void checkAgainstRequiredType(ExpressionVisitor visitor) throws XPathException {
        Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(3, this.variableQName.getDisplayName(), 0);
        SequenceType r = this.requiredType;
        Expression select = this.getSelectExpression();
        if (r != null && select != null) {
            select = visitor.getConfiguration().getTypeChecker(false).staticTypeCheck(select, this.requiredType, role, visitor);
        }
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int s) {
        this.slotNumber = s;
    }

    public void setVariableQName(StructuredQName s) {
        this.variableQName = s;
    }

    @Override
    public StructuredQName getVariableQName() {
        return this.variableQName;
    }

    public void setConversion(Expression convertor) {
        if (convertor != null) {
            if (this.conversionOp == null) {
                this.conversionOp = new Operand(this, convertor, OperandRole.SINGLE_ATOMIC);
            }
        } else {
            this.conversionOp = null;
        }
    }

    public Expression getConversion() {
        return this.conversionOp == null ? null : this.conversionOp.getChildExpression();
    }

    @Override
    public int getInstructionNameCode() {
        return 195;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandSparseList(this.selectOp, this.conversionOp);
    }

    @Override
    public IntegerValue[] getIntegerBoundsForVariable() {
        return null;
    }

    @Override
    public Sequence evaluateVariable(XPathContext c) {
        return c.evaluateLocalVariable(this.slotNumber);
    }

    public boolean isCompatible(LocalParam other) {
        return this.getVariableQName().equals(other.getVariableQName()) && this.getRequiredType().equals(other.getRequiredType()) && this.isTunnelParam() == other.isTunnelParam();
    }

    @Override
    public boolean isLiftable(boolean forStreaming) {
        return false;
    }

    @Override
    public boolean hasVariableBinding(Binding binding) {
        return this == binding;
    }

    @Override
    public ItemType getItemType() {
        return ErrorType.getInstance();
    }

    @Override
    protected int computeCardinality() {
        return 57344;
    }

    @Override
    protected int computeSpecialProperties() {
        return 0x2000000;
    }

    @Override
    public boolean mayCreateNewNodes() {
        return false;
    }

    @Override
    public String getExpressionName() {
        return "param";
    }

    @Override
    public String toShortString() {
        return "$" + this.getVariableQName().getDisplayName();
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        Expression conversion;
        out.startElement("param", this);
        out.emitAttribute("name", this.getVariableQName());
        out.emitAttribute("slot", "" + this.getSlotNumber());
        String flags = this.getFlags();
        if (!flags.isEmpty()) {
            out.emitAttribute("flags", flags);
        }
        if (this.getRequiredType() != SequenceType.ANY_SEQUENCE) {
            out.emitAttribute("as", this.getRequiredType().toAlphaCode());
        }
        if (this.getSelectExpression() != null) {
            out.setChildRole("select");
            this.getSelectExpression().export(out);
        }
        if ((conversion = this.getConversion()) != null) {
            out.setChildRole("conversion");
            conversion.export(out);
        }
        out.endElement();
    }

    private String getFlags() {
        String flags = "";
        if (this.isTunnelParam()) {
            flags = flags + "t";
        }
        if (this.isRequiredParam()) {
            flags = flags + "r";
        }
        if (this.isImplicitlyRequiredParam()) {
            flags = flags + "i";
        }
        return flags;
    }

    @Override
    public void setIndexedVariable() {
    }

    @Override
    public boolean isIndexedVariable() {
        return false;
    }

    @Override
    public Elaborator getElaborator() {
        return new LocalParamElaborator();
    }

    public static class LocalParamElaborator
    extends PushElaborator {
        @Override
        public PushEvaluator elaborateForPush() {
            SequenceEvaluator selectEvaluator;
            LocalParam expr = (LocalParam)this.getExpression();
            if (expr.getSelectExpression() == null) {
                selectEvaluator = null;
            } else if (expr.referenceCount == 10000) {
                PullEvaluator pullEval = expr.getSelectExpression().makeElaborator().elaborateForPull();
                selectEvaluator = new IndexedVariableEvaluator(pullEval);
            } else {
                Expression select = expr.getSelectExpression();
                selectEvaluator = new LearningEvaluator(select, select.makeElaborator().lazily(true, false));
            }
            SequenceEvaluator conversionEval = expr.getConversion() == null ? null : expr.getConversion().makeElaborator().eagerly();
            return (out, context) -> {
                int wasSupplied = context.useLocalParameter(expr.variableQName, expr.slotNumber, expr.isTunnelParam());
                switch (wasSupplied) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        if (conversionEval == null) break;
                        context.setLocalVariable(expr.slotNumber, conversionEval.evaluate(context));
                        break;
                    }
                    case 0: {
                        if (expr.isRequiredParam() || expr.isImplicitlyRequiredParam()) {
                            String name = "$" + expr.getVariableQName().getDisplayName();
                            int suppliedAsTunnel = context.useLocalParameter(expr.variableQName, expr.slotNumber, !expr.isTunnelParam());
                            String message = "No value supplied for required parameter " + name;
                            if (expr.isImplicitlyRequiredParam()) {
                                message = message + ". A value is required because the default value is not a valid instance of the required type";
                            }
                            if (suppliedAsTunnel != 0) {
                                message = expr.isTunnelParam() ? message + ". A non-tunnel parameter with this name was supplied, but a tunnel parameter is required" : message + ". A tunnel parameter with this name was supplied, but a non-tunnel parameter is required";
                            }
                            throw new XPathException(message).withXPathContext(context).withErrorCode("XTDE0700");
                        }
                        if (selectEvaluator == null) {
                            throw new AssertionError((Object)"Internal error: No select expression");
                        }
                        int savedOutputState = context.getTemporaryOutputState();
                        context.setTemporaryOutputState(221);
                        Sequence result = selectEvaluator.evaluate(context);
                        context.setLocalVariable(expr.slotNumber, result);
                        context.setTemporaryOutputState(savedOutputState);
                        return null;
                    }
                }
                return null;
            };
        }
    }
}

