<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:math="http://www.w3.org/2005/xpath-functions/math" xmlns:map="http://www.w3.org/2005/xpath-functions/map" xmlns:doc="http://www.saxonica.com/ns/doc"
    xmlns:f="MyFunctions" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="xs math f doc" version="3.0">

    <doc:synopsis title="Template rank display">
        <p>Generate a set of displays for template ranks</p>
    </doc:synopsis>

    <xsl:variable name="USE-OLD-MAP" select="starts-with(system-property('xsl:product-version'),'9.6')" static="yes"/>
    <xsl:variable name="USE-NEW-MAP" select="not($USE-OLD-MAP)" static="yes"/>
    

    <xsl:mode name="stats.rank" on-no-match="shallow-copy"/>

    <xsl:template match="group[tokenize(@show, '\s+') = 'rank']" mode="stats.rank">
        <xsl:param name="modes.wanted" as="xs:string*" tunnel="yes"/>
        <xsl:param name="svg.root" select="@svg" tunnel="yes"/>       
        <xsl:variable name="modes" select="
                map:merge(stylesheet/mode/map:entry(@name, template))"/> 
        <xsl:for-each
            select="
                if (empty($modes.wanted)) then
                    map:keys($modes)
                else
                    $modes.wanted">
            <xsl:variable name="rules" select="$modes(.)"/>
            <xsl:variable name="ranks" as="element()*">
                <xsl:variable name="ranks">
                    <xsl:for-each-group select="$rules" group-by="@rank">
                        <xsl:sort select="number(@rank)" order="descending"/>
                        <rank rank="{current-grouping-key()}" count="{count(current-group())}" prec="{@prec}" pri="{@prio}"
                            module="{distinct-values(current-group()/@module)}"/>
                    </xsl:for-each-group>
                </xsl:variable>
                <xsl:for-each select="$ranks/*">
                    <xsl:copy>
                        <xsl:sequence select="@*"/>
                        <xsl:variable name="min.order" select="sum(preceding-sibling::*/@count)"/>
                        <xsl:attribute name="min.order" select="$min.order"/>
                        <xsl:attribute name="max.order" select="$min.order + @count"/>
                    </xsl:copy>
                </xsl:for-each>
            </xsl:variable>
             <xsl:variable name="graphics" as="element()*">
                <xsl:apply-templates select="$ranks" mode="svg:barchart">
                    <xsl:with-param name="atts" as="attribute()*" tunnel="yes">
                        <xsl:attribute name="class">rank</xsl:attribute>
                    </xsl:with-param>
                </xsl:apply-templates>
            </xsl:variable>
            <xsl:variable name="g"
                select="map:merge((f:graphics.vals($graphics), 
                map{  
                'axis.y.format':= function($a) {format-number($a idiv 1,'0')} ,
                'label' := ('Template rank distribution','mode:'||.),        
                'axis.y.label' := 'Rank',
                'axis.x.label' := 'Rule order'
                } ))" use-when="$USE-OLD-MAP"/>
            <xsl:variable name="g"
                select="map:merge((f:graphics.vals($graphics), 
                map{  
                'axis.y.format': function($a) {format-number($a idiv 1,'0')} ,
                'label' : ('Template rank distribution','mode:'||.),        
                'axis.y.label' : 'Rank',
                'axis.x.label' : 'Rule order'
                } ))" use-when="$USE-NEW-MAP"/>
            <xsl:call-template name="svg:makeFile">
                <xsl:with-param name="svg.root" select="$svg.root"/>
                <xsl:with-param name="mode" select="."/>
                <xsl:with-param name="g" select="$g"/>
                <xsl:with-param name="name">ranksPlain</xsl:with-param>
                <xsl:with-param name="content" select="$graphics"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>

    <xsl:mode name="svg:barchart" on-no-match="deep-skip"/>
    <xsl:template match="rank" mode="svg:barchart">
        <xsl:param name="atts" as="attribute()*" tunnel="yes"/>
        <xsl:variable name="start" as="xs:integer" select="@min.order"/>
        <xsl:variable name="end" as="xs:integer" select="@max.order"/>
        <line xmlns="http://www.w3.org/2000/svg" class="rank" x1="{$start - 0.5}" x2="{$end + 0.5}" y1="{@rank}" y2="{@rank}">
            <xsl:sequence select="$atts"/>
        </line>
    </xsl:template>

</xsl:stylesheet>
