/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ITemplateCall;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyTemplates
extends Instruction
implements ITemplateCall {
    protected Expression select;
    protected WithParam[] actualParams = WithParam.EMPTY_ARRAY;
    protected WithParam[] tunnelParams = WithParam.EMPTY_ARRAY;
    protected boolean useCurrentMode = false;
    protected boolean useTailRecursion = false;
    protected Mode mode;
    protected boolean implicitSelect;
    protected RuleManager ruleManager;

    protected ApplyTemplates() {
    }

    public ApplyTemplates(Expression select, boolean useCurrentMode, boolean useTailRecursion, boolean implicitSelect, Mode mode, RuleManager ruleManager, Expression threads) {
        this.init(select, useCurrentMode, useTailRecursion, mode);
        this.implicitSelect = implicitSelect;
        this.ruleManager = ruleManager;
    }

    protected void init(Expression select, boolean useCurrentMode, boolean useTailRecursion, Mode mode) {
        this.select = select;
        this.useCurrentMode = useCurrentMode;
        this.useTailRecursion = useTailRecursion;
        this.mode = mode;
        this.adoptChildExpression(select);
    }

    public void setActualParameters(WithParam[] actualParams, WithParam[] tunnelParams) {
        this.actualParams = actualParams;
        this.tunnelParams = tunnelParams;
    }

    @Override
    public int getInstructionNameCode() {
        return 133;
    }

    @Override
    public int getImplementationMethod() {
        return super.getImplementationMethod() | 8;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        WithParam.simplify(this.actualParams, visitor);
        WithParam.simplify(this.tunnelParams, visitor);
        this.select = visitor.simplify(this.select);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        WithParam.typeCheck(this.actualParams, visitor, contextInfo);
        WithParam.typeCheck(this.tunnelParams, visitor, contextInfo);
        try {
            this.select = visitor.typeCheck(this.select, contextInfo);
        }
        catch (XPathException e) {
            if (this.implicitSelect) {
                String code = e.getErrorCodeLocalPart();
                if ("XPTY0020".equals(code) || "XPTY0019".equals(code)) {
                    XPathException err = new XPathException("Cannot apply-templates to child nodes when the context item is an atomic value");
                    err.setErrorCode("XTTE0510");
                    err.setIsTypeError(true);
                    throw err;
                }
                if ("XPDY0002".equals(code)) {
                    XPathException err = new XPathException("Cannot apply-templates to child nodes when the context item is absent");
                    err.setErrorCode("XTTE0510");
                    err.setIsTypeError(true);
                    throw err;
                }
            }
            throw e;
        }
        this.adoptChildExpression(this.select);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        ArrayList<String> reasonsForFailure;
        Optimizer opt;
        Expression e2;
        WithParam.optimize(visitor, this.actualParams, contextItemType);
        WithParam.optimize(visitor, this.tunnelParams, contextItemType);
        this.select = visitor.typeCheck(this.select, contextItemType);
        this.select = visitor.optimize(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (this.mode != null && this.mode.isDeclaredStreamable() && (e2 = (opt = visitor.getConfiguration().obtainOptimizer()).makeStreamingApplyTemplates(this, reasonsForFailure = new ArrayList<String>(2))) != null) {
            return e2;
        }
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return super.getIntrinsicDependencies() | (this.useCurrentMode ? 1 : 0);
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    @Override
    public Expression copy() {
        ApplyTemplates a2 = new ApplyTemplates(this.select.copy(), this.useCurrentMode, this.useTailRecursion, this.implicitSelect, this.mode, this.ruleManager, null);
        a2.actualParams = WithParam.copy(this.actualParams);
        a2.tunnelParams = WithParam.copy(this.tunnelParams);
        a2.ruleManager = this.ruleManager;
        return a2;
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        this.apply(context, false);
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        return this.apply(context, this.useTailRecursion);
    }

    protected TailCall apply(XPathContext context, boolean returnTailCall) throws XPathException {
        Mode thisMode = this.mode;
        if (this.useCurrentMode) {
            thisMode = context.getCurrentMode();
        }
        ParameterSet params = ApplyTemplates.assembleParams(context, this.actualParams);
        ParameterSet tunnels = ApplyTemplates.assembleTunnelParams(context, this.tunnelParams);
        if (returnTailCall) {
            XPathContextMajor c2 = context.newContext();
            c2.setOrigin(this);
            return new ApplyTemplatesPackage(ExpressionTool.lazyEvaluate(this.select, context, 1), thisMode, params, tunnels, c2, this.getLocationId());
        }
        SequenceIterator iter = this.select.iterate(context);
        if (iter instanceof EmptyIterator) {
            return null;
        }
        XPathContextMajor c2 = context.newContext();
        c2.setCurrentIterator(new FocusTrackingIterator(iter));
        c2.setCurrentMode(thisMode);
        c2.setOrigin(this);
        try {
            for (TailCall tc = thisMode.applyTemplates(params, tunnels, c2, this.getLocationId()); tc != null; tc = tc.processLeavingTail()) {
            }
        }
        catch (StackOverflowError e) {
            XPathException err = new XPathException("Too many nested apply-templates calls. The stylesheet may be looping.");
            err.setErrorCode("SXLM0001");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        return null;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>(10);
        list.add(new Operand(this.select, OperandRole.SINGLE_ATOMIC));
        WithParam.gatherOperands(this.actualParams, list);
        WithParam.gatherOperands(this.tunnelParams, list);
        return list;
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (WithParam.replaceXPathExpression(this.actualParams, original, replacement)) {
            found = true;
        }
        if (WithParam.replaceXPathExpression(this.tunnelParams, original, replacement)) {
            found = true;
        }
        return found;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public boolean isImplicitSelect() {
        return this.implicitSelect;
    }

    public boolean useTailRecursion() {
        return this.useTailRecursion;
    }

    public boolean usesCurrentMode() {
        return this.useCurrentMode;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public WithParam[] getActualParams() {
        return this.actualParams;
    }

    @Override
    public WithParam[] getTunnelParams() {
        return this.tunnelParams;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this.select, offer);
        WithParam.promoteParams(this, this.actualParams, offer);
        WithParam.promoteParams(this, this.tunnelParams, offer);
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet result = super.addToPathMap(pathMap, pathMapNodeSet);
        result.setReturnable(false);
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("applyTemplates");
        if (this.mode != null && !this.mode.isDefaultMode()) {
            out.emitAttribute("mode", this.mode.getModeName().getDisplayName());
        }
        this.explainStreaming(out);
        out.startSubsidiaryElement("select");
        this.select.explain(out);
        out.endSubsidiaryElement();
        if (this.actualParams != null && this.actualParams.length > 0) {
            out.startSubsidiaryElement("withParams");
            WithParam.explainParameters(this.actualParams, out);
            out.endSubsidiaryElement();
        }
        if (this.tunnelParams != null && this.tunnelParams.length > 0) {
            out.startSubsidiaryElement("tunnelParams");
            WithParam.explainParameters(this.tunnelParams, out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    protected void explainStreaming(ExpressionPresenter out) {
    }

    protected static class ApplyTemplatesPackage
    implements TailCall {
        private Sequence selectedItems;
        private Mode mode;
        private ParameterSet params;
        private ParameterSet tunnelParams;
        private XPathContextMajor evaluationContext;
        private int locationId;

        ApplyTemplatesPackage(Sequence selectedItems, Mode mode, ParameterSet params, ParameterSet tunnelParams, XPathContextMajor context, int locationId) {
            this.selectedItems = selectedItems;
            this.mode = mode;
            this.params = params;
            this.tunnelParams = tunnelParams;
            this.evaluationContext = context;
            this.locationId = locationId;
        }

        public TailCall processLeavingTail() throws XPathException {
            this.evaluationContext.setCurrentIterator(new FocusTrackingIterator(this.selectedItems.iterate()));
            this.evaluationContext.setCurrentMode(this.mode);
            return this.mode.applyTemplates(this.params, this.tunnelParams, this.evaluationContext, this.locationId);
        }
    }
}

