/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata;

import java.util.List;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.Component;
import net.shibboleth.metadata.pipeline.ComponentInfo;
import org.testng.Assert;

public final class AssertSupport {
    private AssertSupport() {
    }

    public static void assertValidComponentInfo(Item<?> metadataElement, int expectedComponentInfos, Class<? extends Component> expectedComponentType, String expectedComponentId) {
        org.opensaml.util.Assert.isNotNull(metadataElement, (String)"Metadata element must not be null");
        org.opensaml.util.Assert.isGreaterThan((long)0L, (long)expectedComponentInfos, (String)"Expected ComponentInfos must be greater than 0");
        org.opensaml.util.Assert.isNotNull(expectedComponentType, (String)"Expected Component type must not be null");
        org.opensaml.util.Assert.isNotNull((Object)expectedComponentId, (String)"Expected Component ID must not be null");
        List compInfos = metadataElement.getItemMetadata().get(ComponentInfo.class);
        Assert.assertEquals((int)compInfos.size(), (int)expectedComponentInfos);
        for (int i = 0; i < expectedComponentInfos; ++i) {
            ComponentInfo compInfo = (ComponentInfo)compInfos.get(i);
            if (!expectedComponentType.equals(compInfo.getComponentType()) || !expectedComponentId.equals(compInfo.getComponentId())) continue;
            Assert.assertNotNull((Object)compInfo.getCompleteInstant());
            return;
        }
        Assert.fail((String)("Metadata element does not contain a ComponentInfo from a component of type " + expectedComponentType.getCanonicalName() + " with an ID of " + expectedComponentId));
    }
}

