/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.opensaml.util.Assert;
import org.opensaml.util.StringSupport;
import org.opensaml.util.xml.BasicParserPool;
import org.opensaml.util.xml.ParserPool;
import org.opensaml.util.xml.XMLParserException;
import org.testng.annotations.BeforeClass;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseDomTest {
    private BasicParserPool parserPool;

    @BeforeClass
    public void setUp() throws XMLParserException {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        this.parserPool = new BasicParserPool();
        this.parserPool.initialize();
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public Element readXmlData(String path) throws XMLParserException {
        InputStream input;
        String trimmedPath = StringSupport.trimOrNull((String)path);
        Assert.isNotNull((Object)trimmedPath, (String)"Path may not be null or empty");
        if (!trimmedPath.startsWith("/")) {
            trimmedPath = "/data/" + trimmedPath;
        }
        if ((input = BaseDomTest.class.getResourceAsStream(trimmedPath)) == null) {
            throw new XMLParserException(trimmedPath + " does not exist or is not readable");
        }
        return this.parserPool.parse(input).getDocumentElement();
    }

    public void assertXmlIdentical(Node expected, Node actual) {
        Assert.isNotNull((Object)expected, (String)"Expected Node may not be null");
        Assert.isNotNull((Object)actual, (String)"Actual Node may not be null");
        Diff diff = new Diff(expected.getOwnerDocument(), actual.getOwnerDocument());
        if (!diff.identical()) {
            org.testng.Assert.fail((String)diff.toString());
        }
    }
}

