/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import net.shibboleth.metadata.dom.DomFilesystemSourceStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.xml.BasicParserPool;
import org.opensaml.util.xml.ParserPool;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DomFilesystemSourceTest {
    @Test
    public void testSuccessfulFileFetchAndParse() throws Exception {
        URL sourceUrl = DomFilesystemSourceTest.class.getResource("/data/samlMetadata/entityDescriptor1.xml");
        File sourceFile = new File(sourceUrl.toURI());
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DomFilesystemSourceStage source = new DomFilesystemSourceStage();
        source.setId("test");
        source.setParserPool((ParserPool)parserPool);
        source.setSource(sourceFile);
        ArrayList metadataCollection = new ArrayList();
        source.execute(metadataCollection);
        Assert.assertNotNull(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
    }

    @Test
    public void testSuccessfulDirectoryFetchAndParse() throws Exception {
        URL sourceUrl = DomFilesystemSourceTest.class.getResource("/data/samlMetadata");
        File sourceFile = new File(sourceUrl.toURI());
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DomFilesystemSourceStage source = new DomFilesystemSourceStage();
        source.setId("test");
        source.setParserPool((ParserPool)parserPool);
        source.setSource(sourceFile);
        ArrayList metadataCollection = new ArrayList();
        source.execute(metadataCollection);
        Assert.assertNotNull(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)6);
    }

    public void testSuccessfulDirectoryFetchWithFilterAndParse() throws Exception {
        URL sourceUrl = DomFilesystemSourceTest.class.getResource("/data/samlMetadata/entityDescriptor1.xml");
        File sourceFile = new File(sourceUrl.toURI());
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DomFilesystemSourceStage source = new DomFilesystemSourceStage();
        source.setId("test");
        source.setParserPool((ParserPool)parserPool);
        source.setSource(sourceFile);
        source.setRecurseDirectories(true);
        source.setSourceFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith("xml");
            }
        });
        ArrayList metadataCollection = new ArrayList();
        source.execute(metadataCollection);
        Assert.assertNotNull(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)7);
    }

    @Test
    public void testSuccessfulFetchAndFailedParse() throws Exception {
        URL sourceUrl = DomFilesystemSourceTest.class.getResource("/data/loremIpsum.txt");
        File sourceFile = new File(sourceUrl.toURI());
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DomFilesystemSourceStage source = new DomFilesystemSourceStage();
        source.setId("test");
        source.setParserPool((ParserPool)parserPool);
        source.setSource(sourceFile);
        try {
            ArrayList metadataCollection = new ArrayList();
            source.execute(metadataCollection);
            throw new AssertionError((Object)"Source did not fail when given a non-XML file");
        }
        catch (StageProcessingException e) {
            return;
        }
    }

    @Test
    public void testFailedFetch() throws Exception {
        File sourceFile = new File("nonExistant");
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DomFilesystemSourceStage source = new DomFilesystemSourceStage();
        source.setId("test");
        source.setParserPool((ParserPool)parserPool);
        source.setSource(sourceFile);
        try {
            ArrayList metadataCollection = new ArrayList();
            source.execute(metadataCollection);
        }
        catch (StageProcessingException e) {
            throw new AssertionError((Object)"Source did failed when given a nonexistant file");
        }
    }
}

