/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.shibboleth.metadata.dom.DomResourceSourceStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.net.HttpClientBuilder;
import org.opensaml.util.net.HttpResource;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.xml.BasicParserPool;
import org.opensaml.util.xml.ParserPool;
import org.testng.annotations.Test;

public class DomResourceSourceTest {
    @Test
    public void testSuccessfulFetchAndParse() throws Exception {
        HttpResource mdResource = this.buildHttpResource("http://metadata.ukfederation.org.uk/ukfederation-metadata.xml");
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DomResourceSourceStage source = new DomResourceSourceStage();
        source.setId("test");
        source.setDomResource((Resource)mdResource);
        source.setParserPool((ParserPool)parserPool);
        ArrayList metadataCollection = new ArrayList();
        source.execute(metadataCollection);
        assert (metadataCollection != null);
        assert (metadataCollection.size() == 1);
    }

    @Test
    public void testSuccessfulFetchAndFailedParse() throws Exception {
        HttpResource mdResource = this.buildHttpResource("http://www.google.com/intl/en/images/about_logo.gif");
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DomResourceSourceStage source = new DomResourceSourceStage();
        source.setId("test");
        source.setDomResource((Resource)mdResource);
        source.setParserPool((ParserPool)parserPool);
        try {
            ArrayList metadataCollection = new ArrayList();
            source.execute(metadataCollection);
            throw new AssertionError((Object)"Invalid URL marked as parsed");
        }
        catch (StageProcessingException e) {
            return;
        }
    }

    @Test
    public void testFailedFetch() throws Exception {
        HttpResource mdResource = this.buildHttpResource("http://kslkjf.com/lkjlk3.dlw");
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DomResourceSourceStage source = new DomResourceSourceStage();
        source.setId("test");
        source.setDomResource((Resource)mdResource);
        source.setParserPool((ParserPool)parserPool);
        try {
            ArrayList metadataCollection = new ArrayList();
            source.execute(metadataCollection);
            throw new AssertionError((Object)"Invalid URL processed");
        }
        catch (StageProcessingException e) {
            return;
        }
    }

    protected HttpResource buildHttpResource(String url) throws IOException {
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setConnectionDisregardSslCertificate(true);
        builder.setConnectionPooling(false);
        builder.setConnectionStalecheck(false);
        File tmp = File.createTempFile(Long.toString(System.currentTimeMillis()), null);
        tmp.deleteOnExit();
        return new HttpResource(builder.buildClient(), url);
    }
}

