/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import edu.vt.middleware.crypt.util.CryptReader;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import net.shibboleth.metadata.AssertSupport;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.XMLSignatureSigningStage;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSignatureSigningStageTest
extends BaseDomTest {
    @Test
    public void testSigning() throws Exception {
        Element testInput = this.readXmlData("samlMetadata.xml");
        ArrayList<DomElementItem> mdCol = new ArrayList<DomElementItem>();
        mdCol.add(new DomElementItem(testInput));
        PrivateKey signingKey = CryptReader.readPrivateKey((InputStream)XMLSignatureSigningStageTest.class.getResourceAsStream("/data/signingKey.pem"));
        X509Certificate signingCert = (X509Certificate)CryptReader.readCertificate((InputStream)XMLSignatureSigningStageTest.class.getResourceAsStream("/data/signingCert.pem"));
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.add(signingCert);
        XMLSignatureSigningStage stage = new XMLSignatureSigningStage();
        stage.setId("test");
        stage.setIncludeKeyValue(false);
        stage.setIncludeX509IssuerSerial(true);
        stage.setPrivateKey(signingKey);
        stage.setCertificates(certs);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        DomElementItem result = (DomElementItem)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XMLSignatureSigningStage.class, "test");
        Element expected = this.readXmlData("signedSamlMetadata.xml");
        this.assertXmlIdentical(expected, (Node)result.unwrap());
    }
}

