/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import edu.vt.middleware.crypt.util.CryptReader;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import net.shibboleth.metadata.AssertSupport;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.XMLSignatureSigningStageTest;
import net.shibboleth.metadata.dom.XMLSignatureValidationStage;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class XMLSignatureValidationStageTest
extends BaseDomTest {
    @Test
    public void testValidSignature() throws Exception {
        Element testInput = this.readXmlData("signedSamlMetadata.xml");
        ArrayList<DomElementItem> mdCol = new ArrayList<DomElementItem>();
        mdCol.add(new DomElementItem(testInput));
        Certificate signingCert = CryptReader.readCertificate((InputStream)XMLSignatureSigningStageTest.class.getResourceAsStream("/data/signingCert.pem"));
        XMLSignatureValidationStage stage = new XMLSignatureValidationStage();
        stage.setId("test");
        stage.setVerificationCertificate(signingCert);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        DomElementItem result = (DomElementItem)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XMLSignatureValidationStage.class, "test");
    }

    @Test
    public void testInvalidSignature() throws Exception {
        Element testInput = this.readXmlData("badSignatureSamlMetadata.xml");
        DomElementItem item = new DomElementItem(testInput);
        ArrayList<DomElementItem> mdCol = new ArrayList<DomElementItem>();
        mdCol.add(item);
        Certificate signingCert = CryptReader.readCertificate((InputStream)XMLSignatureSigningStageTest.class.getResourceAsStream("/data/signingCert.pem"));
        XMLSignatureValidationStage stage = new XMLSignatureValidationStage();
        stage.setId("test");
        stage.setVerificationCertificate(signingCert);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertTrue((boolean)item.getItemMetadata().containsKey(ErrorStatus.class));
    }

    @Test
    public void testRequiredSignature() throws Exception {
        Element testInput = this.readXmlData("samlMetadata/entitiesDescriptor2.xml");
        DomElementItem item = new DomElementItem(testInput);
        ArrayList<DomElementItem> mdCol = new ArrayList<DomElementItem>();
        mdCol.add(item);
        Certificate signingCert = CryptReader.readCertificate((InputStream)XMLSignatureSigningStageTest.class.getResourceAsStream("/data/signingCert.pem"));
        XMLSignatureValidationStage stage = new XMLSignatureValidationStage();
        stage.setId("test");
        stage.setSignatureRequired(false);
        stage.setVerificationCertificate(signingCert);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        DomElementItem result = (DomElementItem)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XMLSignatureValidationStage.class, "test");
        item = new DomElementItem(testInput);
        mdCol = new ArrayList();
        mdCol.add(item);
        stage = new XMLSignatureValidationStage();
        stage.setId("test");
        stage.setSignatureRequired(true);
        stage.setVerificationCertificate(signingCert);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertTrue((boolean)item.getItemMetadata().containsKey(ErrorStatus.class));
    }
}

