/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.EntityRegistrationAuthorityFilterStage;
import org.opensaml.util.collections.CollectionSupport;
import org.opensaml.util.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EntityRegistrationAuthorityFilterStageTest
extends BaseDomTest {
    @Test
    public void testAuthorityWhitelist() throws Exception {
        EntityRegistrationAuthorityFilterStage stage = new EntityRegistrationAuthorityFilterStage();
        stage.setId("test");
        stage.setRequiringRegistrationInformation(false);
        stage.setWhitelistingRegistrationAuthorities(true);
        stage.setDesignatedRegistrationAuthorities((Collection)CollectionSupport.toList((Object[])new String[]{"urn:example.org:authority2"}));
        stage.initialize();
        Collection<DomElementItem> mdCollection = this.buildMetadataCollection();
        Assert.assertEquals((int)mdCollection.size(), (int)3);
        stage.execute(mdCollection);
        Assert.assertEquals((int)mdCollection.size(), (int)2);
    }

    @Test
    public void testAuthorityBlacklist() throws Exception {
        EntityRegistrationAuthorityFilterStage stage = new EntityRegistrationAuthorityFilterStage();
        stage.setId("test");
        stage.setWhitelistingRegistrationAuthorities(false);
        stage.setRequiringRegistrationInformation(false);
        stage.setDesignatedRegistrationAuthorities((Collection)CollectionSupport.toList((Object[])new String[]{"urn:example.org:authority2"}));
        stage.initialize();
        Collection<DomElementItem> mdCollection = this.buildMetadataCollection();
        Assert.assertEquals((int)mdCollection.size(), (int)3);
        stage.execute(mdCollection);
        Assert.assertEquals((int)mdCollection.size(), (int)1);
    }

    @Test
    public void testRequireRegistrationInfo() throws Exception {
        EntityRegistrationAuthorityFilterStage stage = new EntityRegistrationAuthorityFilterStage();
        stage.setId("test");
        stage.setRequiringRegistrationInformation(true);
        stage.setWhitelistingRegistrationAuthorities(false);
        stage.setDesignatedRegistrationAuthorities((Collection)CollectionSupport.toList((Object[])new String[]{"urn:example.org:authority1", "urn:example.org:authority2"}));
        stage.initialize();
        ArrayList<DomElementItem> mdCollection = new ArrayList<DomElementItem>();
        mdCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        Assert.assertEquals((int)mdCollection.size(), (int)1);
        stage.execute(mdCollection);
        Assert.assertEquals((int)mdCollection.size(), (int)0);
    }

    @Test
    public void testRemoveEntitylessEntitiesDescriptor() throws Exception {
        EntityRegistrationAuthorityFilterStage stage = new EntityRegistrationAuthorityFilterStage();
        stage.setId("test");
        stage.setRequiringRegistrationInformation(true);
        stage.setRemovingEntitylessEntitiesDescriptor(true);
        stage.setWhitelistingRegistrationAuthorities(false);
        stage.setDesignatedRegistrationAuthorities((Collection)CollectionSupport.toList((Object[])new String[]{"urn:example.org:authority1", "urn:example.org:authority2"}));
        stage.initialize();
        ArrayList<DomElementItem> mdCollection = new ArrayList<DomElementItem>();
        mdCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        Assert.assertEquals((int)mdCollection.size(), (int)1);
        stage.execute(mdCollection);
        Assert.assertEquals((int)mdCollection.size(), (int)0);
    }

    @Test
    public void testDontRemoveEntitylessEntitiesDescriptor() throws Exception {
        EntityRegistrationAuthorityFilterStage stage = new EntityRegistrationAuthorityFilterStage();
        stage.setId("test");
        stage.setRemovingEntitylessEntitiesDescriptor(false);
        stage.setRequiringRegistrationInformation(false);
        stage.setWhitelistingRegistrationAuthorities(false);
        stage.setDesignatedRegistrationAuthorities((Collection)CollectionSupport.toList((Object[])new String[]{"urn:example.org:authority1", "urn:example.org:authority2"}));
        stage.initialize();
        ArrayList<DomElementItem> mdCollection = new ArrayList<DomElementItem>();
        mdCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        Assert.assertEquals((int)mdCollection.size(), (int)1);
        stage.execute(mdCollection);
        Assert.assertEquals((int)mdCollection.size(), (int)1);
        Assert.assertEquals((int)ElementSupport.getChildElements((Node)((Node)((DomElementItem)mdCollection.get(0)).unwrap())).size(), (int)0);
    }

    private Collection<DomElementItem> buildMetadataCollection() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        List descriptors = ElementSupport.getChildElements((Node)this.readXmlData("samlMetadata/entitiesDescriptor1.xml"));
        for (Element descriptor : descriptors) {
            metadataCollection.add(new DomElementItem(descriptor));
        }
        return metadataCollection;
    }
}

