/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.PullUpCacheDurationStage;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import org.opensaml.util.xml.AttributeSupport;
import org.opensaml.util.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PullCacheDurationStageTest
extends BaseDomTest {
    @Test
    public void testPullCacheDuration() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        PullUpCacheDurationStage stage = new PullUpCacheDurationStage();
        stage.setId("test");
        stage.execute(metadataCollection);
        Element entitiesDescriptor = (Element)((DomElementItem)metadataCollection.get(0)).unwrap();
        Attr durationAttr = AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
        Assert.assertNotNull((Object)durationAttr);
        long duration = AttributeSupport.getDurationAttributeValueAsLong((Attr)durationAttr);
        Assert.assertEquals((long)duration, (long)3600000L);
        List entityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SamlMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        Assert.assertEquals((int)entityDescriptors.size(), (int)3);
        for (Element entityDescriptor : entityDescriptors) {
            Assert.assertFalse((boolean)AttributeSupport.hasAttribute((Element)entityDescriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME));
        }
    }

    @Test
    public void testMinCacheDuration() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        PullUpCacheDurationStage stage = new PullUpCacheDurationStage();
        stage.setId("test");
        stage.setMinimumCacheDuration(0x6DDD00L);
        stage.execute(metadataCollection);
        Element entitiesDescriptor = (Element)((DomElementItem)metadataCollection.get(0)).unwrap();
        Attr durationAttr = AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
        Assert.assertNotNull((Object)durationAttr);
        long duration = AttributeSupport.getDurationAttributeValueAsLong((Attr)durationAttr);
        Assert.assertEquals((long)duration, (long)0x6DDD00L);
    }

    @Test
    public void testMaxCacheDuration() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        PullUpCacheDurationStage stage = new PullUpCacheDurationStage();
        stage.setId("test");
        stage.setMaximumCacheDuration(1800000L);
        stage.execute(metadataCollection);
        Element entitiesDescriptor = (Element)((DomElementItem)metadataCollection.get(0)).unwrap();
        Attr durationAttr = AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
        Assert.assertNotNull((Object)durationAttr);
        long duration = AttributeSupport.getDurationAttributeValueAsLong((Attr)durationAttr);
        Assert.assertEquals((long)duration, (long)1800000L);
    }
}

