/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.PullUpValidUntilStage;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import org.opensaml.util.xml.AttributeSupport;
import org.opensaml.util.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PullUpValidUntilStageTest
extends BaseDomTest {
    @Test
    public void testPullCacheDuration() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        PullUpValidUntilStage stage = new PullUpValidUntilStage();
        stage.setId("test");
        stage.execute(metadataCollection);
        Element entitiesDescriptor = (Element)((DomElementItem)metadataCollection.get(0)).unwrap();
        Attr validUntilAttr = AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME);
        Assert.assertNotNull((Object)validUntilAttr);
        long validUntil = AttributeSupport.getDateTimeAttributeAsLong((Attr)validUntilAttr);
        Assert.assertEquals((long)validUntil, (long)2429913600000L);
        List entityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SamlMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        Assert.assertEquals((int)entityDescriptors.size(), (int)3);
        for (Element entityDescriptor : entityDescriptors) {
            Assert.assertFalse((boolean)AttributeSupport.hasAttribute((Element)entityDescriptor, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME));
        }
    }

    @Test
    public void testMinCacheDuration() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        long hundredYears = 3153600000000L;
        PullUpValidUntilStage stage = new PullUpValidUntilStage();
        stage.setId("test");
        stage.setMinimumValidityDuration(hundredYears);
        stage.execute(metadataCollection);
        Element entitiesDescriptor = (Element)((DomElementItem)metadataCollection.get(0)).unwrap();
        Attr validUntilAttr = AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME);
        Assert.assertNotNull((Object)validUntilAttr);
        long validUntil = AttributeSupport.getDateTimeAttributeAsLong((Attr)validUntilAttr);
        Assert.assertTrue((validUntil > System.currentTimeMillis() + hundredYears - 60000L ? 1 : 0) != 0);
    }

    @Test
    public void testMaxCacheDuration() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        long twoYears = 63072000000L;
        PullUpValidUntilStage stage = new PullUpValidUntilStage();
        stage.setId("test");
        stage.setMaximumValidityDuration(twoYears);
        stage.execute(metadataCollection);
        Element entitiesDescriptor = (Element)((DomElementItem)metadataCollection.get(0)).unwrap();
        Attr validUntilAttr = AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME);
        Assert.assertNotNull((Object)validUntilAttr);
        long validUntil = AttributeSupport.getDateTimeAttributeAsLong((Attr)validUntilAttr);
        Assert.assertTrue((validUntil < System.currentTimeMillis() + twoYears ? 1 : 0) != 0);
    }
}

