/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.RemoveContactPersonStage;
import org.opensaml.util.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RemoveContactPersonStageTest
extends BaseDomTest {
    @Test
    public void testRemoveContactPerson() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        List descriptors = ElementSupport.getChildElements((Node)this.readXmlData("samlMetadata/entitiesDescriptor1.xml"));
        for (Element descriptor : descriptors) {
            metadataCollection.add(new DomElementItem(descriptor));
        }
        for (DomElementItem metadata : metadataCollection) {
            Assert.assertFalse((boolean)ElementSupport.getChildElementsByTagNameNS((Node)((Node)metadata.unwrap()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"ContactPerson").isEmpty());
        }
        RemoveContactPersonStage stage = new RemoveContactPersonStage();
        stage.setId("test");
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)3);
        for (DomElementItem metadata : metadataCollection) {
            Assert.assertTrue((boolean)ElementSupport.getChildElementsByTagNameNS((Node)((Node)metadata.unwrap()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"ContactPerson").isEmpty());
        }
    }

    @Test
    public void testRemoveContactPersonFromNestedElements() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        Element entitiesDescriptor = (Element)((DomElementItem)metadataCollection.get(0)).unwrap();
        List entityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor);
        for (Element entityDescriptor : entityDescriptors) {
            Assert.assertFalse((boolean)ElementSupport.getChildElementsByTagNameNS((Node)entityDescriptor, (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"ContactPerson").isEmpty());
        }
        RemoveContactPersonStage stage = new RemoveContactPersonStage();
        stage.setId("test");
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
        for (Element entityDescriptor : entityDescriptors) {
            Assert.assertTrue((boolean)ElementSupport.getChildElementsByTagNameNS((Node)entityDescriptor, (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"ContactPerson").isEmpty());
        }
    }
}

