/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.dom.BaseDomTest;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.RemoveOrganizationStage;
import org.opensaml.util.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RemoveOrganizationStageTest
extends BaseDomTest {
    @Test
    public void testRemoveOrganization() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        List descriptors = ElementSupport.getChildElements((Node)this.readXmlData("samlMetadata/entitiesDescriptor1.xml"));
        for (Element descriptor : descriptors) {
            metadataCollection.add(new DomElementItem(descriptor));
        }
        for (DomElementItem metadata : metadataCollection) {
            Assert.assertFalse((boolean)ElementSupport.getChildElementsByTagNameNS((Node)((Node)metadata.unwrap()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"Organization").isEmpty());
        }
        RemoveOrganizationStage stage = new RemoveOrganizationStage();
        stage.setId("test");
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)3);
        for (DomElementItem metadata : metadataCollection) {
            Assert.assertTrue((boolean)ElementSupport.getChildElementsByTagNameNS((Node)((Node)metadata.unwrap()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"Organization").isEmpty());
        }
    }

    @Test
    public void testRemoveOrganizationFromNestedElements() throws Exception {
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(this.readXmlData("samlMetadata/entitiesDescriptor1.xml")));
        Element entitiesDescriptor = (Element)((DomElementItem)metadataCollection.get(0)).unwrap();
        List entityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor);
        for (Element entityDescriptor : entityDescriptors) {
            Assert.assertFalse((boolean)ElementSupport.getChildElementsByTagNameNS((Node)entityDescriptor, (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"Organization").isEmpty());
        }
        RemoveOrganizationStage stage = new RemoveOrganizationStage();
        stage.setId("test");
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
        for (Element entityDescriptor : entityDescriptors) {
            Assert.assertTrue((boolean)ElementSupport.getChildElementsByTagNameNS((Node)entityDescriptor, (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"Organization").isEmpty());
        }
    }
}

