/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.dom.saml.SetValidUntilStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import org.opensaml.util.xml.AttributeSupport;
import org.opensaml.util.xml.BasicParserPool;
import org.opensaml.util.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetValidUntilStageTest {
    @Test
    public void testWithoutExistingValidUntil() throws Exception {
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        Element entitiesDescriptor = parserPool.parse(SetValidUntilStageTest.class.getResourceAsStream("/data/samlMetadata.xml")).getDocumentElement();
        entitiesDescriptor.removeAttributeNS(null, SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME.getLocalPart());
        Assert.assertTrue((AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME) == null ? 1 : 0) != 0);
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(entitiesDescriptor));
        long duration = 123456L;
        long now = System.currentTimeMillis();
        SetValidUntilStage stage = new SetValidUntilStage();
        stage.setId("test");
        stage.setValidityDuration(duration);
        stage.initialize();
        stage.execute(metadataCollection);
        Attr validUntilAttr = AttributeSupport.getAttribute((Element)((Element)((DomElementItem)metadataCollection.iterator().next()).unwrap()), (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME);
        Assert.assertNotNull((Object)validUntilAttr);
        long validUntil = AttributeSupport.getDateTimeAttributeAsLong((Attr)validUntilAttr);
        Assert.assertTrue((validUntil > now + duration - 100L ? 1 : 0) != 0);
        Assert.assertTrue((validUntil < now + duration + 100L ? 1 : 0) != 0);
    }

    @Test
    public void testWithExistingValidUntil() throws Exception {
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        Element entitiesDescriptor = parserPool.parse(SetValidUntilStageTest.class.getResourceAsStream("/data/samlMetadata.xml")).getDocumentElement();
        Assert.assertTrue((boolean)AttributeSupport.hasAttribute((Element)entitiesDescriptor, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME));
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(entitiesDescriptor));
        long duration = 123456L;
        long now = System.currentTimeMillis();
        SetValidUntilStage stage = new SetValidUntilStage();
        stage.setId("test");
        stage.setValidityDuration(duration);
        stage.initialize();
        stage.execute(metadataCollection);
        Attr validUntilAttr = AttributeSupport.getAttribute((Element)((Element)((DomElementItem)metadataCollection.iterator().next()).unwrap()), (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME);
        Assert.assertNotNull((Object)validUntilAttr);
        long validUntil = AttributeSupport.getDateTimeAttributeAsLong((Attr)validUntilAttr);
        Assert.assertTrue((validUntil > now + duration - 100L ? 1 : 0) != 0);
        Assert.assertTrue((validUntil < now + duration + 100L ? 1 : 0) != 0);
    }

    @Test
    public void testWithNonDescriptorMetadataElement() throws Exception {
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        Document newDoc = parserPool.newDocument();
        Element root = newDoc.createElementNS("http://example.org", "foo");
        ElementSupport.setDocumentElement((Document)newDoc, (Element)root);
        ArrayList<DomElementItem> metadataCollection = new ArrayList<DomElementItem>();
        metadataCollection.add(new DomElementItem(root));
        long duration = 123456L;
        SetValidUntilStage stage = new SetValidUntilStage();
        stage.setId("test");
        stage.setValidityDuration(duration);
        stage.initialize();
        stage.execute(metadataCollection);
        Attr validUntilAttr = AttributeSupport.getAttribute((Element)root, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME);
        Assert.assertNull((Object)validUntilAttr);
    }

    @Test
    public void testNegativeDuration() {
        long duration = -987654L;
        SetValidUntilStage stage = new SetValidUntilStage();
        stage.setId("test");
        try {
            stage.setValidityDuration(duration);
            stage.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException e) {
            // empty catch block
        }
    }
}

