/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.InfoStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.pipeline.ItemMetadataTerminationStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ItemMetadataTerminationStageTest {
    private Collection<Item<?>> metadataCollectionPrototype;
    private Item md1;
    private Item md2;
    private Item md3;
    private Item md4;

    @BeforeTest
    public void setup() {
        this.metadataCollectionPrototype = new ArrayList();
        this.md1 = new MockItem("1");
        this.metadataCollectionPrototype.add(this.md1);
        this.md2 = new MockItem("2");
        this.md2.getItemMetadata().put((Object)new WarningStatus("2", "warning"));
        this.metadataCollectionPrototype.add(this.md2);
        this.md3 = new MockItem("3");
        this.metadataCollectionPrototype.add(this.md3);
        this.md4 = new MockItem("4");
        this.md4.getItemMetadata().put((Object)new WarningStatus("4", "warning"));
        this.md4.getItemMetadata().put((Object)new ErrorStatus("4", "error"));
        this.metadataCollectionPrototype.add(this.md4);
    }

    @Test
    public void testNoSelectionRequirements() throws Exception {
        ArrayList metadataCollection = new ArrayList(this.metadataCollectionPrototype);
        ItemMetadataTerminationStage stage = new ItemMetadataTerminationStage();
        try {
            stage.execute(metadataCollection);
            Assert.assertEquals((int)metadataCollection.size(), (int)4);
            Assert.assertTrue((boolean)metadataCollection.contains(this.md1));
            Assert.assertTrue((boolean)metadataCollection.contains(this.md2));
            Assert.assertTrue((boolean)metadataCollection.contains(this.md3));
            Assert.assertTrue((boolean)metadataCollection.contains(this.md4));
        }
        catch (StageProcessingException e) {
            Assert.fail((String)"Stage failed unexpectedly");
        }
    }

    @Test
    public void testSingleSelectionRequirement() throws Exception {
        ArrayList metadataCollection = new ArrayList(this.metadataCollectionPrototype);
        ArrayList<Class<ErrorStatus>> filterRequirements = new ArrayList<Class<ErrorStatus>>();
        filterRequirements.add(ErrorStatus.class);
        ItemMetadataTerminationStage stage = new ItemMetadataTerminationStage();
        stage.setSelectionRequirements(filterRequirements);
        try {
            stage.execute(metadataCollection);
            Assert.fail((String)"Stage did not fail as expected");
        }
        catch (StageProcessingException e) {
            // empty catch block
        }
    }

    @Test
    public void testMultiSelectionRequirement() throws Exception {
        ArrayList metadataCollection = new ArrayList(this.metadataCollectionPrototype);
        ArrayList<Class<ErrorStatus>> filterRequirements = new ArrayList<Class<ErrorStatus>>();
        filterRequirements.add(InfoStatus.class);
        filterRequirements.add(WarningStatus.class);
        filterRequirements.add(ErrorStatus.class);
        ItemMetadataTerminationStage stage = new ItemMetadataTerminationStage();
        stage.setSelectionRequirements(filterRequirements);
        try {
            stage.execute(metadataCollection);
            Assert.fail((String)"Stage did not fail as expected");
        }
        catch (StageProcessingException e) {
            // empty catch block
        }
    }
}

