/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.pipeline.AbstractComponent;
import net.shibboleth.metadata.pipeline.ComponentInfo;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.CountingStage;
import net.shibboleth.metadata.pipeline.SimplePipeline;
import net.shibboleth.metadata.pipeline.Stage;
import net.shibboleth.metadata.pipeline.StaticItemSourceStage;
import org.opensaml.util.collections.CollectionSupport;
import org.opensaml.util.collections.LazyList;
import org.testng.annotations.Test;

public class SimplePipelineTest {
    @Test
    public void testInitialize() throws Exception {
        List<Stage<MockItem>> stages = this.buildStages();
        SimplePipeline pipeline = new SimplePipeline();
        pipeline.setId(" test ");
        pipeline.setStages(stages);
        assert ("test".equals(pipeline.getId()));
        assert (pipeline.getStages() != stages);
        assert (pipeline.getStages().size() == 3);
        assert (pipeline.getStages().containsAll(stages));
        assert (!((Stage)pipeline.getStages().get(0)).isInitialized());
        assert (!((Stage)pipeline.getStages().get(1)).isInitialized());
        assert (pipeline.getInitializationInstant() == null);
        pipeline.initialize();
        assert ("test".equals(pipeline.getId()));
        assert (pipeline.getStages() != stages);
        assert (pipeline.getStages().size() == 3);
        assert (pipeline.getStages().containsAll(stages));
        assert (((Stage)pipeline.getStages().get(0)).isInitialized());
        assert (((Stage)pipeline.getStages().get(1)).isInitialized());
        assert (((Stage)pipeline.getStages().get(2)).isInitialized());
        assert (pipeline.getInitializationInstant() != null);
        try {
            pipeline = new SimplePipeline();
            pipeline.setStages(stages);
            pipeline.initialize();
            throw new AssertionError();
        }
        catch (ComponentInitializationException e) {
            try {
                pipeline = new SimplePipeline();
                pipeline.setId("");
                pipeline.setStages(stages);
                pipeline.initialize();
                throw new AssertionError();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }
    }

    @Test
    public void testExecution() throws Exception {
        List<Stage<MockItem>> stages = this.buildStages();
        SimplePipeline pipeline = new SimplePipeline();
        pipeline.setId("test");
        pipeline.setStages(stages);
        ArrayList metadata = new ArrayList();
        pipeline.execute(metadata);
        assert (metadata.size() == 2);
        assert (((CountingStage)stages.get(1)).getInvocationCount() == 1);
        assert (((CountingStage)stages.get(2)).getInvocationCount() == 1);
        MockItem md = (MockItem)((Object)metadata.iterator().next());
        assert (md.getItemMetadata().containsKey(ComponentInfo.class));
        assert (md.getItemMetadata().values().size() == 2);
        assert (md.getItemMetadata().containsKey(ComponentInfo.class));
        try {
            List pipelineStages = pipeline.getStages();
            pipelineStages.clear();
            throw new AssertionError();
        }
        catch (UnsupportedOperationException e) {
            metadata = new ArrayList();
            pipeline.execute(metadata);
            assert (metadata.size() == 2);
            assert (((CountingStage)stages.get(1)).getInvocationCount() == 2);
            assert (((CountingStage)stages.get(2)).getInvocationCount() == 2);
            return;
        }
    }

    protected List<Stage<MockItem>> buildStages() {
        MockItem md1 = new MockItem("one");
        MockItem md2 = new MockItem("two");
        StaticItemSourceStage source = new StaticItemSourceStage();
        source.setId("src");
        source.setSourceItems((Collection)CollectionSupport.toList((Object[])new MockItem[]{md1, md2}));
        CountingStage stage1 = new CountingStage();
        CountingStage stage2 = new CountingStage();
        LazyList stages = CollectionSupport.toList((Object[])new AbstractComponent[]{source, stage1, stage2});
        return stages;
    }
}

