/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.shibboleth.metadata.AlwaysItemSelectionStrategy;
import net.shibboleth.metadata.ItemCollectionFactory;
import net.shibboleth.metadata.ItemSelectionStrategy;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.SimpleItemCollectionFactory;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.CountingStage;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.SimplePipeline;
import net.shibboleth.metadata.pipeline.SplitMergeStage;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SplitMergeStageTest {
    @Test
    public void testCollectionFactory() {
        SplitMergeStage stage = new SplitMergeStage();
        SimpleItemCollectionFactory factory = new SimpleItemCollectionFactory();
        stage.setCollectionFactory((ItemCollectionFactory)factory);
        Assert.assertEquals((Object)stage.getCollectionFactory(), (Object)factory);
    }

    @Test
    public void testExecutorService() {
        SplitMergeStage stage = new SplitMergeStage();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        stage.setExecutorService(executor);
        Assert.assertEquals((Object)stage.getExecutorService(), (Object)executor);
    }

    @Test
    public void testNonselectedItemPipeline() {
        SplitMergeStage stage = new SplitMergeStage();
        SimplePipeline pipeline = new SimplePipeline();
        stage.setNonselectedItemPipeline((Pipeline)pipeline);
        Assert.assertSame((Object)stage.getNonselectedItemPipeline(), (Object)pipeline);
    }

    @Test
    public void testSelectedItemPipeline() {
        SplitMergeStage stage = new SplitMergeStage();
        SimplePipeline pipeline = new SimplePipeline();
        stage.setSelectedItemPipeline((Pipeline)pipeline);
        Assert.assertSame((Object)stage.getSelectedItemPipeline(), (Object)pipeline);
    }

    @Test
    public void testSelectionStrategy() {
        SplitMergeStage stage = new SplitMergeStage();
        AlwaysItemSelectionStrategy strategy = new AlwaysItemSelectionStrategy();
        stage.setSelectionStrategy((ItemSelectionStrategy)strategy);
        Assert.assertEquals((Object)stage.getSelectionStrategy(), (Object)strategy);
    }

    @Test
    public void testInitialization() throws Exception {
        SimplePipeline pipeline = new SimplePipeline();
        pipeline.setId("pipeline");
        SplitMergeStage stage = new SplitMergeStage();
        stage.setId("test");
        stage.setNonselectedItemPipeline((Pipeline)pipeline);
        stage.setSelectedItemPipeline((Pipeline)pipeline);
        stage.setSelectionStrategy((ItemSelectionStrategy)new AlwaysItemSelectionStrategy());
        stage.initialize();
        Assert.assertNotNull((Object)stage.getCollectionFactory());
        Assert.assertNotNull((Object)stage.getExecutorService());
        stage = new SplitMergeStage();
        stage.setId("test");
        stage.setSelectedItemPipeline((Pipeline)pipeline);
        stage.setSelectionStrategy((ItemSelectionStrategy)new AlwaysItemSelectionStrategy());
        stage.initialize();
        stage = new SplitMergeStage();
        stage.setId("test");
        stage.setNonselectedItemPipeline((Pipeline)pipeline);
        stage.setSelectionStrategy((ItemSelectionStrategy)new AlwaysItemSelectionStrategy());
        stage.initialize();
        try {
            stage = new SplitMergeStage();
            stage.setId("test");
            stage.setSelectionStrategy((ItemSelectionStrategy)new AlwaysItemSelectionStrategy());
            stage.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException e) {
            // empty catch block
        }
        try {
            stage = new SplitMergeStage();
            stage.setId("test");
            stage.setNonselectedItemPipeline((Pipeline)pipeline);
            stage.setSelectedItemPipeline((Pipeline)pipeline);
            stage.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void testExecute() throws Exception {
        SimplePipeline selectedPipeline = new SimplePipeline();
        selectedPipeline.setId("selectedPipeline");
        CountingStage selectedCount = new CountingStage();
        selectedPipeline.setStages(Collections.singletonList(selectedCount));
        SimplePipeline nonselectedPipeline = new SimplePipeline();
        nonselectedPipeline.setId("nonselectedPipeline");
        CountingStage nonselectedCount = new CountingStage();
        nonselectedPipeline.setStages(Collections.singletonList(nonselectedCount));
        MockItem item1 = new MockItem("one");
        MockItem item2 = new MockItem("two");
        MockItem item3 = new MockItem("three");
        ArrayList<MockItem> items = new ArrayList<MockItem>();
        items.add(item1);
        items.add(item2);
        items.add(item3);
        SplitMergeStage stage = new SplitMergeStage();
        stage.setId("test");
        stage.setSelectionStrategy((ItemSelectionStrategy)new AlwaysItemSelectionStrategy());
        stage.setNonselectedItemPipeline((Pipeline)nonselectedPipeline);
        stage.setSelectedItemPipeline((Pipeline)selectedPipeline);
        stage.initialize();
        stage.execute(items);
        Assert.assertEquals((int)selectedCount.getInvocationCount(), (int)1);
        Assert.assertEquals((int)selectedCount.getItemCount(), (int)3);
        Assert.assertEquals((int)nonselectedCount.getInvocationCount(), (int)1);
        Assert.assertEquals((int)nonselectedCount.getItemCount(), (int)0);
        Assert.assertEquals((int)items.size(), (int)3);
        Assert.assertTrue((boolean)items.contains((Object)item1));
        Assert.assertTrue((boolean)items.contains((Object)item2));
        Assert.assertTrue((boolean)items.contains((Object)item3));
    }
}

