/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.util;

import java.io.Serializable;
import java.util.List;
import net.shibboleth.metadata.util.ClassToInstanceMultiMap;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractDateTime;
import org.joda.time.base.AbstractInstant;
import org.joda.time.base.BaseDateTime;
import org.testng.annotations.Test;

public class ClassToInstanceMultiMapTest {
    @Test
    public void testClearIsEmpty() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap();
        map.clear();
        assert (map.isEmpty());
        map.put(new Object());
        assert (!map.isEmpty());
        map.clear();
        assert (map.isEmpty());
    }

    @Test
    public void testKeysAndContainsKey() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap();
        this.populate((ClassToInstanceMultiMap<AbstractInstant>)map);
        assert (map.keys().size() == 2);
        assert (!map.containsKey(null));
        assert (!map.containsKey(Chronology.class));
        assert (!map.containsKey(AbstractInstant.class));
        assert (!map.containsKey(AbstractDateTime.class));
        assert (!map.containsKey(BaseDateTime.class));
        assert (map.containsKey(DateTime.class));
        assert (!map.containsKey(Comparable.class));
        assert (!map.containsKey(ReadableDateTime.class));
        assert (!map.containsKey(ReadableInstant.class));
        assert (!map.containsKey(Serializable.class));
        assert (map.containsKey(Instant.class));
        map = new ClassToInstanceMultiMap(true);
        this.populate((ClassToInstanceMultiMap<AbstractInstant>)map);
        assert (map.keys().size() == 9);
        assert (!map.containsKey(null));
        assert (!map.containsKey(Chronology.class));
        assert (map.containsKey(AbstractInstant.class));
        assert (map.containsKey(AbstractDateTime.class));
        assert (map.containsKey(BaseDateTime.class));
        assert (map.containsKey(DateTime.class));
        assert (map.containsKey(Comparable.class));
        assert (map.containsKey(ReadableDateTime.class));
        assert (map.containsKey(ReadableInstant.class));
        assert (map.containsKey(Serializable.class));
        assert (map.containsKey(Instant.class));
    }

    @Test
    public void testValuesAndContainsValues() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap();
        DateTime now = new DateTime();
        map.put((Object)now);
        DateTime now100 = now.plus(100L);
        map.put((Object)now100);
        Instant instant = new Instant();
        map.put((Object)instant);
        assert (map.values().size() == 3);
        assert (!map.containsValue(null));
        assert (!map.containsValue((Object)now.minus(100L)));
        assert (!map.containsValue((Object)instant.minus(100L)));
        assert (map.containsValue((Object)instant));
        assert (map.containsValue((Object)now));
        assert (map.containsValue((Object)now100));
    }

    @Test
    public void testEquals() {
    }

    @Test
    public void testGet() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap();
        this.populate((ClassToInstanceMultiMap<AbstractInstant>)map);
        List values = map.get(null);
        assert (values.size() == 0);
        values = map.get(DateTime.class);
        assert (values.size() == 2);
        values = map.get(Instant.class);
        assert (values.size() == 1);
    }

    protected void populate(ClassToInstanceMultiMap<AbstractInstant> map) {
        DateTime now = new DateTime();
        map.put((Object)now);
        DateTime now100 = now.plus(100L);
        map.put((Object)now100);
        Instant instant = new Instant();
        map.put((Object)instant);
    }
}

