/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata;

import java.util.List;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.metadata.ItemIdentificationStrategy;
import org.opensaml.util.Assert;
import org.opensaml.util.StringSupport;

public class FirstItemIdItemIdentificationStrategy
implements ItemIdentificationStrategy {
    private String noItemIdIdentifier = "unidentified";

    public String getNoItemIdIdentifier() {
        return this.noItemIdIdentifier;
    }

    public void setNoItemIdIdentifier(String identifier) {
        String trimmedId = StringSupport.trimOrNull((String)identifier);
        this.noItemIdIdentifier = (String)Assert.isNotNull((Object)trimmedId, (String)"Identifier can not be null or empty");
    }

    @Override
    public String getItemIdentifier(Item<?> item) {
        List<ItemId> itemIds = item.getItemMetadata().get(ItemId.class);
        if (itemIds != null && !itemIds.isEmpty()) {
            return itemIds.get(0).getId();
        }
        return this.noItemIdIdentifier;
    }
}

