/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.AbstractItem;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.util.ItemMetadataSupport;
import org.opensaml.util.Assert;
import org.opensaml.util.xml.ElementSupport;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ThreadSafe
public class DomElementItem
extends AbstractItem<Element> {
    private static final long serialVersionUID = -5122481126094725529L;

    public DomElementItem(Document document) {
        Assert.isNotNull((Object)document, (String)"DOM Document can not be null");
        Element docElement = document.getDocumentElement();
        Assert.isNotNull((Object)docElement, (String)"DOM Document Element may not be null");
        this.setData(document.getDocumentElement());
    }

    public DomElementItem(Element element) {
        Assert.isNotNull((Object)element, (String)"DOM Document Element may not be null");
        DOMImplementation domImpl = element.getOwnerDocument().getImplementation();
        Document newDocument = domImpl.createDocument(null, null, null);
        Element newDocumentRoot = (Element)newDocument.importNode(element, true);
        ElementSupport.setDocumentElement((Document)newDocument, (Element)newDocumentRoot);
        this.setData(newDocumentRoot);
    }

    @Override
    public Item<Element> copy() {
        DomElementItem clone = new DomElementItem((Element)this.unwrap());
        ItemMetadataSupport.addToAll(clone, this.getItemMetadata().values().toArray(new ItemMetadata[0]));
        return clone;
    }
}

