/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.CloseableSupport;
import org.opensaml.util.xml.ParserPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@ThreadSafe
public class DomFilesystemSourceStage
extends BaseStage<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(DomFilesystemSourceStage.class);
    private ParserPool parserPool;
    private File sourceFile;
    private FileFilter sourceFileFilter;
    private boolean recurseDirectories;
    private boolean noSourceFilesAnError;
    private boolean errorCausesSourceFailure = true;

    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public synchronized void setParserPool(ParserPool pool) {
        if (this.isInitialized()) {
            return;
        }
        this.parserPool = pool;
    }

    public File getSource() {
        return this.sourceFile;
    }

    public synchronized void setSource(File source) {
        if (this.isInitialized()) {
            return;
        }
        this.sourceFile = source;
    }

    public FileFilter getSourceFileFilter() {
        return this.sourceFileFilter;
    }

    public synchronized void setSourceFileFilter(FileFilter filter) {
        if (this.isInitialized()) {
            return;
        }
        this.sourceFileFilter = filter;
    }

    public boolean getRecurseDirectories() {
        return this.recurseDirectories;
    }

    public synchronized void setRecurseDirectories(boolean recurse) {
        if (this.isInitialized()) {
            return;
        }
        this.recurseDirectories = recurse;
    }

    public boolean isNoSourceFilesAnError() {
        return this.noSourceFilesAnError;
    }

    public synchronized void setNoSourceFilesAnError(boolean isError) {
        if (this.isInitialized()) {
            return;
        }
        this.noSourceFilesAnError = isError;
    }

    public boolean getErrorCausesSourceFailure() {
        return this.errorCausesSourceFailure;
    }

    public synchronized void setErrorCausesSourceFailure(boolean causesFailure) {
        if (this.isInitialized()) {
            return;
        }
        this.errorCausesSourceFailure = causesFailure;
    }

    @Override
    protected void doExecute(Collection<DomElementItem> itemCollection) throws StageProcessingException {
        ArrayList<File> sourceFiles = new ArrayList<File>();
        if (this.sourceFile.isFile()) {
            sourceFiles.add(this.sourceFile);
        } else {
            this.getSourceFiles(this.sourceFile, sourceFiles);
        }
        if (sourceFiles.isEmpty()) {
            if (!this.noSourceFilesAnError) {
                this.log.warn("stage {}: no input XML files in source path {}", (Object)this.getId(), (Object)this.sourceFile.getPath());
                return;
            }
            throw new StageProcessingException("stage " + this.getId() + ": no source file was available for parsing");
        }
        for (File source : sourceFiles) {
            DomElementItem dme = this.processSourceFile(source);
            if (dme == null) continue;
            itemCollection.add(dme);
        }
    }

    protected void getSourceFiles(File input, List<File> collector) {
        if (input.isFile()) {
            if (this.sourceFileFilter == null || this.sourceFileFilter.accept(input)) {
                collector.add(input);
            }
            return;
        }
        File[] files = this.sourceFile.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() && (!file.isDirectory() || !this.recurseDirectories)) continue;
                this.getSourceFiles(file, collector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DomElementItem processSourceFile(File source) throws StageProcessingException {
        DomElementItem domElementItem;
        FileInputStream xmlIn = null;
        try {
            this.log.debug("{} pipeline source parsing XML file {}", (Object)this.getId(), (Object)source.getPath());
            xmlIn = new FileInputStream(source);
            Document doc = this.parserPool.parse((InputStream)xmlIn);
            domElementItem = new DomElementItem(doc);
        }
        catch (Exception e) {
            DomElementItem domElementItem2;
            try {
                if (this.errorCausesSourceFailure) {
                    throw new StageProcessingException(this.getId() + " pipeline source unable to parse XML input file " + source.getPath(), e);
                }
                this.log.warn("{} pipeline source: unable to parse XML source file {}, ignoring it bad file", new Object[]{this.getId(), source.getPath(), e});
                domElementItem2 = null;
            }
            catch (Throwable throwable) {
                CloseableSupport.closeQuietly(xmlIn);
                throw throwable;
            }
            CloseableSupport.closeQuietly((Closeable)xmlIn);
            return domElementItem2;
        }
        CloseableSupport.closeQuietly((Closeable)xmlIn);
        return domElementItem;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.parserPool == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", ParserPool may not be null");
        }
        if (this.sourceFile == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", Source may not be null");
        }
        if (!this.sourceFile.exists() || !this.sourceFile.canRead()) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", source file/directory " + this.sourceFile.getPath() + " can not be read");
        }
    }
}

