/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Collection;
import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.CloseableSupport;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.util.xml.ParserPool;
import org.opensaml.util.xml.XMLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DomResourceSourceStage
extends BaseStage<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(DomResourceSourceStage.class);
    private Resource domResource;
    private ParserPool parserPool;
    private boolean errorCausesSourceFailure = true;

    public Resource getDomResource() {
        return this.domResource;
    }

    public synchronized void setDomResource(Resource resource) {
        if (this.isInitialized()) {
            return;
        }
        this.domResource = resource;
    }

    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public synchronized void setParserPool(ParserPool pool) {
        if (this.isInitialized()) {
            return;
        }
        this.parserPool = pool;
    }

    public boolean getErrorCausesSourceFailure() {
        return this.errorCausesSourceFailure;
    }

    public synchronized void setErrorCausesSourceFailure(boolean causesFailure) {
        if (this.isInitialized()) {
            return;
        }
        this.errorCausesSourceFailure = causesFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(Collection<DomElementItem> itemCollection) throws StageProcessingException {
        InputStream ins;
        block6: {
            ins = null;
            try {
                this.log.debug("Attempting to fetch XML document from '{}'", (Object)this.domResource.getLocation());
                ins = this.domResource.getInputStream();
                if (ins == null) {
                    this.log.debug("Resource at location '{}' did not produce any data to parse, nothing left to do", (Object)this.domResource.getLocation());
                    break block6;
                }
                this.log.debug("DOM Element from '{}' unchanged since last request, using cached copy", (Object)this.domResource.getLocation());
                this.populateItemCollection(itemCollection, ins);
            }
            catch (ResourceException e) {
                try {
                    if (this.errorCausesSourceFailure) {
                        throw new StageProcessingException("Error retrieving XML document from " + this.domResource.getLocation(), (Exception)((Object)e));
                    }
                    this.log.warn("stage {}: unable to read in XML file");
                    this.log.debug("stage {}: HTTP resource exception", (Object)this.getId(), (Object)e);
                }
                catch (Throwable throwable) {
                    CloseableSupport.closeQuietly(ins);
                    throw throwable;
                }
                CloseableSupport.closeQuietly((Closeable)ins);
            }
        }
        CloseableSupport.closeQuietly((Closeable)ins);
    }

    protected void populateItemCollection(Collection<DomElementItem> itemCollection, InputStream data) throws StageProcessingException {
        try {
            this.log.debug("Parsing XML document retrieved from '{}'", (Object)this.domResource.getLocation());
            itemCollection.add(new DomElementItem(this.parserPool.parse(data)));
        }
        catch (XMLParserException e) {
            if (this.errorCausesSourceFailure) {
                throw new StageProcessingException("Unable to parse returned XML document", (Exception)((Object)e));
            }
            this.log.warn("stage {}: unable to parse XML document", (Object)this.getId());
            this.log.debug("stage {}: parsing exception", (Object)this.getId(), (Object)e);
        }
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.parserPool == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", ParserPool may not be null");
        }
        if (this.domResource == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", either a DomResource must be specified");
        }
        try {
            if (!this.domResource.exists()) {
                throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", DOM resource " + this.domResource.getLocation() + " does not exist");
            }
        }
        catch (ResourceException e) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", error reading DOM resource " + this.domResource.getLocation() + " information", (Exception)((Object)e));
        }
    }
}

