/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import net.jcip.annotations.ThreadSafe;
import org.opensaml.util.StringSupport;

@ThreadSafe
public class SimpleNamespaceContext
implements NamespaceContext {
    private final Map<String, String> prefixMappings;

    public SimpleNamespaceContext() {
        this.prefixMappings = Collections.emptyMap();
    }

    public SimpleNamespaceContext(Map<String, String> mappings) {
        if (mappings == null || mappings.isEmpty()) {
            this.prefixMappings = Collections.emptyMap();
            return;
        }
        HashMap<String, String> checkedMappings = new HashMap<String, String>();
        for (String key : mappings.keySet()) {
            String trimmedValue;
            String trimmedKey = StringSupport.trimOrNull((String)key);
            if (trimmedKey == null || (trimmedValue = StringSupport.trimOrNull((String)mappings.get(key))) == null) continue;
            checkedMappings.put(trimmedKey, trimmedValue);
        }
        this.prefixMappings = checkedMappings == null || checkedMappings.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(checkedMappings);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.prefixMappings.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        throw new UnsupportedOperationException();
    }
}

