/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.collections.CollectionSupport;
import org.opensaml.util.collections.LazyList;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.xml.SchemaBuilder;
import org.opensaml.util.xml.SerializeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@ThreadSafe
public class XMLSchemaValidationStage
extends BaseIteratingStage<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(XMLSchemaValidationStage.class);
    private List<Resource> schemaResources = Collections.emptyList();
    private boolean elementRequiredToBeSchemaValid = true;
    private Schema validationSchema;

    public List<Resource> getSchemaResources() {
        return this.schemaResources;
    }

    public synchronized void setSchemaResources(List<Resource> resources) {
        if (this.isInitialized()) {
            return;
        }
        this.schemaResources = Collections.unmodifiableList((List)CollectionSupport.addNonNull(resources, (Collection)new LazyList()));
    }

    public boolean isElementRequiredToBeSchemaValid() {
        return this.elementRequiredToBeSchemaValid;
    }

    public synchronized void setElementRequiredToBeSchemaValid(boolean isRequired) {
        if (this.isInitialized()) {
            return;
        }
        this.elementRequiredToBeSchemaValid = isRequired;
    }

    @Override
    protected boolean doExecute(DomElementItem item) throws StageProcessingException {
        this.log.debug("{} pipeline stage schema validating DOM Element collection elements", (Object)this.getId());
        Validator validator = this.validationSchema.newValidator();
        try {
            validator.validate(new DOMSource((Node)item.unwrap()));
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("DOM Element was not valid:\n{}", (Object)SerializeSupport.prettyPrintXML((Node)((Node)item.unwrap())), (Object)e);
            }
            if (this.elementRequiredToBeSchemaValid) {
                item.getItemMetadata().put(new ErrorStatus(this.getId(), e.getMessage()));
            }
            item.getItemMetadata().put(new WarningStatus(this.getId(), e.getMessage()));
        }
        return true;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.schemaResources == null || this.schemaResources.isEmpty()) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", SchemaResources may not be empty");
        }
        try {
            this.log.debug("{} pipeline stage building validation schema resources", (Object)this.getId());
            this.validationSchema = SchemaBuilder.buildSchema((SchemaBuilder.SchemaLanguage)SchemaBuilder.SchemaLanguage.XML, (Resource[])this.schemaResources.toArray(new Resource[this.schemaResources.size()]));
        }
        catch (SAXException e) {
            throw new ComponentInitializationException("Unable to generate schema", e);
        }
    }
}

