/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.namespace.QName;
import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.apache.xml.security.Init;
import org.opensaml.util.StringSupport;
import org.opensaml.util.collections.CollectionSupport;
import org.opensaml.util.collections.LazyList;
import org.opensaml.util.xml.QNameSupport;
import org.opensaml.util.xml.XmlConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@ThreadSafe
public class XMLSignatureSigningStage
extends BaseIteratingStage<DomElementItem> {
    public static final String XML_SIG_NS_URI = "http://www.w3.org/2000/09/xmldsig#";
    public static final QName SIGNATURE_NAME = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");
    public static final String XML_ENC_NS_URI = "http://www.w3.org/2001/04/xmlenc#";
    public static final String RFC4501_BASE_URI = "http://www.w3.org/2001/04/xmldsig-more";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    public static final String ALGO_ID_DIGEST_SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String ALGO_ID_DIGEST_SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String ALGO_ID_DIGEST_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#sha384";
    public static final String ALGO_ID_DIGEST_SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String ALGO_ID_C14N_OMIT_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String ALGO_ID_C14N_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String ALGO_ID_C14N_EXCL_OMIT_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String ALGO_ID_C14N_EXCL_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String TRANSFORM_ENVELOPED_SIGNATURE = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    private final Logger log = LoggerFactory.getLogger(XMLSignatureSigningStage.class);
    private XMLSignatureFactory xmlSigFactory;
    private KeyInfoFactory keyInfoFactory;
    private ShaVariant shaVariant = ShaVariant.SHA256;
    private PrivateKey privKey;
    private PublicKey pubKey;
    private List<X509Certificate> certificates = Collections.emptyList();
    private List<X509CRL> crls = Collections.emptyList();
    private String sigAlgo;
    private String digestAlgo;
    private boolean c14nExclusive = true;
    private boolean c14nWithComments;
    private String c14nAlgo;
    private List<String> inclusivePrefixList = Collections.emptyList();
    private List<QName> idAttributeNames = Collections.emptyList();
    private List<String> keyNames = Collections.emptyList();
    private boolean deriveKeyNames = true;
    private boolean includeKeyNames = true;
    private boolean includeKeyValue;
    private boolean includeX509SubjectName;
    private boolean includeX509Certificates = true;
    private boolean includeX509Crls;
    private boolean includeX509IssuerSerial;

    public ShaVariant getShaVariant() {
        return this.shaVariant;
    }

    public synchronized void setShaVariant(ShaVariant variant) {
        if (this.isInitialized()) {
            return;
        }
        this.shaVariant = variant;
    }

    public PrivateKey getPrivateKey() {
        return this.privKey;
    }

    public synchronized void setPrivateKey(PrivateKey key) {
        if (this.isInitialized()) {
            return;
        }
        this.privKey = key;
    }

    public PublicKey getPublicKey() {
        return this.pubKey;
    }

    public synchronized void setPublicKey(PublicKey key) {
        if (this.isInitialized()) {
            return;
        }
        this.pubKey = key;
    }

    public List<X509Certificate> getCertificates() {
        return this.certificates;
    }

    public synchronized void setCertificates(List<X509Certificate> certs) {
        if (this.isInitialized()) {
            return;
        }
        this.certificates = (List)CollectionSupport.addNonNull(certs, (Collection)new LazyList());
    }

    public List<X509CRL> getCrls() {
        return this.crls;
    }

    public synchronized void setCrls(List<X509CRL> revocationLists) {
        if (this.isInitialized()) {
            return;
        }
        this.crls = (List)CollectionSupport.addNonNull(revocationLists, (Collection)new LazyList());
    }

    public boolean isC14nExclusive() {
        return this.c14nExclusive;
    }

    public synchronized void setC14nExclusive(boolean isExclusive) {
        if (this.isInitialized()) {
            return;
        }
        this.c14nExclusive = isExclusive;
    }

    public boolean isC14nWithComments() {
        return this.c14nWithComments;
    }

    public synchronized void setC14nWithComments(boolean withComments) {
        if (this.isInitialized()) {
            return;
        }
        this.c14nWithComments = withComments;
    }

    public List<String> getInclusivePrefixList() {
        return this.inclusivePrefixList;
    }

    public synchronized void setInclusivePrefixList(List<String> prefixList) {
        if (this.isInitialized()) {
            return;
        }
        this.inclusivePrefixList = (List)CollectionSupport.addNonNull(prefixList, (Collection)new LazyList());
    }

    public List<QName> getIdAttributeNames() {
        return this.idAttributeNames;
    }

    public synchronized void setIdAttributeNames(List<QName> names) {
        if (this.isInitialized()) {
            return;
        }
        this.idAttributeNames = (List)CollectionSupport.addNonNull(names, (Collection)new LazyList());
    }

    public List<String> getKeyNames() {
        return this.keyNames;
    }

    public synchronized void setKeyNames(List<String> names) {
        if (this.isInitialized()) {
            return;
        }
        this.keyNames = (List)CollectionSupport.addNonNull(names, (Collection)new LazyList());
    }

    public boolean isDeriveKeyNames() {
        return this.deriveKeyNames;
    }

    public synchronized void setDeriveKeyNames(boolean deriveNames) {
        if (this.isInitialized()) {
            return;
        }
        this.deriveKeyNames = deriveNames;
    }

    public boolean isIncludeKeyNames() {
        return this.includeKeyNames;
    }

    public synchronized void setIncludeKeyNames(boolean include) {
        if (this.isInitialized()) {
            return;
        }
        this.includeKeyNames = include;
    }

    public boolean isIncludeKeyValue() {
        return this.includeKeyValue;
    }

    public synchronized void setIncludeKeyValue(boolean included) {
        if (this.isInitialized()) {
            return;
        }
        this.includeKeyValue = included;
    }

    public boolean isIncludeX509SubjectName() {
        return this.includeX509SubjectName;
    }

    public synchronized void setIncludeX509SubjectName(boolean include) {
        if (this.isInitialized()) {
            return;
        }
        this.includeX509SubjectName = include;
    }

    public boolean isIncludeX509Certificates() {
        return this.includeX509Certificates;
    }

    public synchronized void setIncludeX509Certificates(boolean include) {
        if (this.isInitialized()) {
            return;
        }
        this.includeX509Certificates = include;
    }

    public boolean isIncludeX509Crls() {
        return this.includeX509Crls;
    }

    public synchronized void setIncludeX509Crls(boolean include) {
        if (this.isInitialized()) {
            return;
        }
        this.includeX509Crls = include;
    }

    public boolean isIncludeX509IssuerSerial() {
        return this.includeX509IssuerSerial;
    }

    public synchronized void setIncludeX509IssuerSerial(boolean include) {
        if (this.isInitialized()) {
            return;
        }
        this.includeX509IssuerSerial = include;
    }

    public String getSigAlgo() {
        return this.sigAlgo;
    }

    public String getDigestAlgo() {
        return this.digestAlgo;
    }

    @Override
    protected boolean doExecute(DomElementItem item) throws StageProcessingException {
        Element element = (Element)item.unwrap();
        XMLSignature signature = this.xmlSigFactory.newXMLSignature(this.buildSignedInfo(element), this.buildKeyInfo());
        try {
            signature.sign(new DOMSignContext(this.privKey, (Node)element, element.getFirstChild()));
        }
        catch (Exception e) {
            this.log.error("Unable to create signature for element", (Throwable)e);
            throw new StageProcessingException("Unable to create signature for element", e);
        }
        return true;
    }

    protected SignedInfo buildSignedInfo(Element target) throws StageProcessingException {
        SignatureMethod sigMethod;
        CanonicalizationMethod c14nMethod;
        ExcC14NParameterSpec c14nMethodSpec = null;
        if (this.c14nAlgo.startsWith(ALGO_ID_C14N_EXCL_OMIT_COMMENTS) && this.inclusivePrefixList != null && !this.inclusivePrefixList.isEmpty()) {
            c14nMethodSpec = new ExcC14NParameterSpec(this.inclusivePrefixList);
        }
        try {
            c14nMethod = this.xmlSigFactory.newCanonicalizationMethod(this.c14nAlgo, c14nMethodSpec);
        }
        catch (Exception e) {
            String errMsg = "Unable to create transform " + this.c14nAlgo;
            this.log.error(errMsg, (Throwable)e);
            throw new StageProcessingException(errMsg, e);
        }
        try {
            sigMethod = this.xmlSigFactory.newSignatureMethod(this.sigAlgo, null);
        }
        catch (Exception e) {
            String errMsg = "Unable to create signature method " + this.sigAlgo;
            this.log.error(errMsg, (Throwable)e);
            throw new StageProcessingException(errMsg, e);
        }
        List<Reference> refs = Collections.singletonList(this.buildSignatureReference(target));
        return this.xmlSigFactory.newSignedInfo(c14nMethod, sigMethod, refs);
    }

    protected Reference buildSignatureReference(Element target) throws StageProcessingException {
        ExcC14NParameterSpec transformSpec;
        String id = this.getElementId(target);
        String refUri = id == null ? "" : "#" + id;
        DigestMethod digestMethod = null;
        try {
            DigestMethodParameterSpec digestMethodSpec = null;
            digestMethod = this.xmlSigFactory.newDigestMethod(this.digestAlgo, digestMethodSpec);
        }
        catch (Exception e) {
            String errMsg = "Unable to create digest method " + this.digestAlgo;
            this.log.error(errMsg, (Throwable)e);
            throw new StageProcessingException(errMsg, e);
        }
        ArrayList<Transform> transforms = new ArrayList<Transform>();
        try {
            transformSpec = null;
            transforms.add(this.xmlSigFactory.newTransform(TRANSFORM_ENVELOPED_SIGNATURE, transformSpec));
        }
        catch (Exception e) {
            String errMsg = "Unable to create transform http://www.w3.org/2000/09/xmldsig#enveloped-signature";
            this.log.error(errMsg, (Throwable)e);
            throw new StageProcessingException(errMsg, e);
        }
        try {
            if (this.c14nAlgo.startsWith(ALGO_ID_C14N_EXCL_OMIT_COMMENTS) && this.inclusivePrefixList != null && !this.inclusivePrefixList.isEmpty()) {
                transformSpec = new ExcC14NParameterSpec(this.inclusivePrefixList);
            }
            transforms.add(this.xmlSigFactory.newTransform(this.c14nAlgo, transformSpec));
        }
        catch (Exception e) {
            String errMsg = "Unable to create transform " + this.c14nAlgo;
            this.log.error(errMsg, (Throwable)e);
            throw new StageProcessingException(errMsg, e);
        }
        return this.xmlSigFactory.newReference(refUri, digestMethod, transforms, null, null);
    }

    protected String getElementId(Element target) {
        String value;
        Attr attribute;
        int i;
        NamedNodeMap attributes = target.getAttributes();
        if (attributes == null || attributes.getLength() < 1) {
            return null;
        }
        if (this.idAttributeNames != null && !this.idAttributeNames.isEmpty()) {
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = (Attr)attributes.item(i);
                if (!this.idAttributeNames.contains(QNameSupport.getNodeQName((Node)attribute)) || (value = StringSupport.trimOrNull((String)attribute.getValue())) == null) continue;
                return value;
            }
        }
        for (i = 0; i < attributes.getLength(); ++i) {
            attribute = (Attr)attributes.item(i);
            if (!attribute.isId() || (value = StringSupport.trimOrNull((String)attribute.getValue())) == null) continue;
            return value;
        }
        return null;
    }

    protected KeyInfo buildKeyInfo() throws StageProcessingException {
        ArrayList<Object> keyInfoItems = new ArrayList<Object>();
        this.addKeyNames(keyInfoItems);
        this.addKeyValue(keyInfoItems);
        this.addX509Data(keyInfoItems);
        if (keyInfoItems.isEmpty()) {
            return null;
        }
        return this.keyInfoFactory.newKeyInfo(keyInfoItems);
    }

    protected void addKeyNames(ArrayList<Object> keyInfoItems) throws StageProcessingException {
        if (!this.includeKeyNames) {
            return;
        }
        if (this.keyNames != null && !this.keyNames.isEmpty()) {
            for (String name : this.keyNames) {
                keyInfoItems.add(this.keyInfoFactory.newKeyName(name));
            }
        }
        if (this.deriveKeyNames) {
            // empty if block
        }
    }

    protected void addKeyValue(ArrayList<Object> keyInfoItems) throws StageProcessingException {
        X509Certificate cert;
        if (!this.includeKeyValue) {
            return;
        }
        PublicKey key = this.pubKey;
        if (key == null && this.certificates != null && (cert = this.certificates.get(0)) != null) {
            key = cert.getPublicKey();
        }
        if (key != null) {
            try {
                keyInfoItems.add(this.keyInfoFactory.newKeyValue(key));
            }
            catch (Exception e) {
                this.log.error("Unable to create KeyValue", (Throwable)e);
                throw new StageProcessingException("Unable to create KeyValue", e);
            }
        }
    }

    protected void addX509Data(ArrayList<Object> keyInfoItems) throws StageProcessingException {
        ArrayList<Object> x509Data = new ArrayList<Object>();
        if (this.certificates != null && !this.certificates.isEmpty()) {
            X509Certificate endEntityCert = this.certificates.get(0);
            if (this.includeX509SubjectName) {
                X500Principal subjectDn = endEntityCert.getSubjectX500Principal();
                keyInfoItems.add(subjectDn.getName("RFC2253"));
            }
            if (this.includeX509Certificates) {
                x509Data.addAll(this.certificates);
            }
            if (this.includeX509IssuerSerial) {
                X500Principal issuerDn = endEntityCert.getIssuerX500Principal();
                BigInteger serialNumber = endEntityCert.getSerialNumber();
                x509Data.add(this.keyInfoFactory.newX509IssuerSerial(issuerDn.getName("RFC2253"), serialNumber));
            }
        }
        if (this.includeX509Crls && this.crls != null && !this.crls.isEmpty()) {
            x509Data.add(this.crls);
        }
        if (!x509Data.isEmpty()) {
            keyInfoItems.add(this.keyInfoFactory.newX509Data(x509Data));
        }
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!Init.isInitialized()) {
            Init.isInitialized();
        }
        this.xmlSigFactory = XMLSignatureFactory.getInstance();
        this.keyInfoFactory = this.xmlSigFactory.getKeyInfoFactory();
        switch (this.shaVariant) {
            case SHA1: {
                this.sigAlgo = ALGO_ID_SIGNATURE_RSA_SHA1;
                this.digestAlgo = ALGO_ID_DIGEST_SHA1;
                break;
            }
            case SHA384: {
                this.sigAlgo = ALGO_ID_SIGNATURE_RSA_SHA384;
                this.digestAlgo = ALGO_ID_DIGEST_SHA384;
                break;
            }
            case SHA512: {
                this.sigAlgo = ALGO_ID_SIGNATURE_RSA_SHA512;
                this.digestAlgo = ALGO_ID_DIGEST_SHA512;
                break;
            }
            default: {
                this.sigAlgo = ALGO_ID_SIGNATURE_RSA_SHA256;
                this.digestAlgo = ALGO_ID_DIGEST_SHA256;
            }
        }
        this.c14nAlgo = this.c14nExclusive ? (this.c14nWithComments ? ALGO_ID_C14N_EXCL_WITH_COMMENTS : ALGO_ID_C14N_EXCL_OMIT_COMMENTS) : (this.c14nWithComments ? ALGO_ID_C14N_WITH_COMMENTS : ALGO_ID_C14N_OMIT_COMMENTS);
        if (this.idAttributeNames == null) {
            this.idAttributeNames = new ArrayList<QName>();
            this.idAttributeNames.add(new QName("id"));
            this.idAttributeNames.add(new QName("Id"));
            this.idAttributeNames.add(new QName("ID"));
            this.idAttributeNames.add(XmlConstants.XML_ID_ATTRIB_NAME);
        }
    }

    public static enum ShaVariant {
        SHA1,
        SHA256,
        SHA384,
        SHA512;

    }
}

