/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.opensaml.util.xml.ElementSupport;
import org.opensaml.util.xml.SerializeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class XMLSignatureValidationStage
extends BaseIteratingStage<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(XMLSignatureValidationStage.class);
    private boolean signatureRequired = true;
    private boolean validSignatureRequired = true;
    private Certificate verificationCertificate;
    private PublicKey verificationKey;

    public boolean isSignatureRequired() {
        return this.signatureRequired;
    }

    public synchronized void setSignatureRequired(boolean required) {
        if (this.isInitialized()) {
            return;
        }
        this.signatureRequired = required;
    }

    public boolean isValidSignatureRequired() {
        return this.validSignatureRequired;
    }

    public synchronized void setValidSignatureRequired(boolean isRequired) {
        if (this.isInitialized()) {
            return;
        }
        this.validSignatureRequired = isRequired;
    }

    public PublicKey getVerificationKey() {
        return this.verificationKey;
    }

    public synchronized void setVerificationKey(PublicKey key) {
        if (this.isInitialized()) {
            return;
        }
        this.verificationKey = key;
    }

    public Certificate getVerificationCertificate() {
        return this.verificationCertificate;
    }

    public synchronized void setVerificationCertificate(Certificate certificate) {
        if (this.isInitialized()) {
            return;
        }
        if (certificate != null) {
            this.verificationCertificate = certificate;
            this.verificationKey = certificate.getPublicKey();
        }
    }

    @Override
    protected boolean doExecute(DomElementItem item) throws StageProcessingException {
        Element signatureElement = this.getSignatureElement((Element)item.unwrap());
        if (signatureElement == null) {
            if (this.signatureRequired) {
                this.log.debug("DOM Element was not signed and signature is required");
                item.getItemMetadata().put(new ErrorStatus(this.getId(), "DOM Element was not signed but signatures are required"));
            } else {
                this.log.debug("DOM Element is not signed, no verification performed");
            }
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("DOM Element contained Signature element\n{}", (Object)SerializeSupport.prettyPrintXML((Node)signatureElement));
        }
        if (!this.signatureVerified(signatureElement)) {
            if (this.validSignatureRequired) {
                item.getItemMetadata().put(new ErrorStatus(this.getId(), "element signature is invalid"));
            } else {
                item.getItemMetadata().put(new WarningStatus(this.getId(), "element signature is invalid"));
            }
        }
        return true;
    }

    protected boolean signatureVerified(Element signatureElement) throws StageProcessingException {
        XMLSignature signature;
        this.log.debug("Creating XML security library XMLSignature object");
        try {
            signature = new XMLSignature(signatureElement, "");
        }
        catch (XMLSecurityException e) {
            this.log.debug("Unable to read XML signature", (Throwable)e);
            return false;
        }
        try {
            if (signature.checkSignatureValue((Key)this.verificationKey)) {
                this.log.debug("DOM Element signature verified.");
                return true;
            }
            this.log.debug("DOM Element signature did not verify.");
            return false;
        }
        catch (XMLSignatureException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unable to validate signature", (Throwable)e);
            }
            return false;
        }
    }

    protected Element getSignatureElement(Element root) throws StageProcessingException {
        List sigElements = ElementSupport.getChildElementsByTagNameNS((Node)root, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        if (sigElements.isEmpty()) {
            return null;
        }
        if (sigElements.size() > 1) {
            throw new StageProcessingException("DOM Element contained more than one signature");
        }
        return (Element)sigElements.get(0);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.verificationKey == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", VerificationKey must not be null");
        }
        if (!Init.isInitialized()) {
            Init.init();
        }
    }
}

