/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.SimpleNamespaceContext;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import org.opensaml.util.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class XPathFilteringStage
extends BaseStage<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(XPathFilteringStage.class);
    private String xpathExpression;
    private NamespaceContext namespaceContext;

    public String getXpathExpression() {
        return this.xpathExpression;
    }

    public synchronized void setXpathExpression(String expression) {
        if (this.isInitialized()) {
            return;
        }
        this.xpathExpression = StringSupport.trimOrNull((String)expression);
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public synchronized void setNamespaceContext(NamespaceContext context) {
        if (this.isInitialized()) {
            return;
        }
        this.namespaceContext = context;
    }

    @Override
    public void doExecute(Collection<DomElementItem> metadataCollection) {
        XPathExpression compiledExpression;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        if (this.namespaceContext != null) {
            xpath.setNamespaceContext(this.namespaceContext);
        }
        try {
            compiledExpression = xpath.compile(this.xpathExpression);
        }
        catch (XPathExpressionException e) {
            this.log.error("error compiling XPath expression; no filtering performed", (Throwable)e);
            return;
        }
        Iterator<DomElementItem> iterator = metadataCollection.iterator();
        while (iterator.hasNext()) {
            DomElementItem item = iterator.next();
            try {
                Boolean filterThis = (Boolean)compiledExpression.evaluate(item.unwrap(), XPathConstants.BOOLEAN);
                if (!filterThis.booleanValue()) continue;
                this.log.debug("removing item matching XPath condition");
                iterator.remove();
            }
            catch (XPathExpressionException e) {
                this.log.error("removing item due to XPath expression error", (Throwable)e);
                iterator.remove();
            }
        }
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.xpathExpression == null) {
            throw new ComponentInitializationException("XPath expression can not be null or empty");
        }
        if (this.namespaceContext == null) {
            this.namespaceContext = new SimpleNamespaceContext();
        }
    }
}

