/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.ItemSelectionStrategy;
import net.shibboleth.metadata.dom.DomElementItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class XPathItemSelectionStrategy
implements ItemSelectionStrategy<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(XPathItemSelectionStrategy.class);
    private final XPathExpression compiledExpression;
    private final NamespaceContext namespaceContext;

    public XPathItemSelectionStrategy(String expression, NamespaceContext context) throws XPathExpressionException {
        this.namespaceContext = context;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        if (this.namespaceContext != null) {
            xpath.setNamespaceContext(this.namespaceContext);
        }
        this.compiledExpression = xpath.compile(expression);
    }

    @Override
    public synchronized boolean isSelectedItem(DomElementItem item) {
        try {
            return (Boolean)this.compiledExpression.evaluate(item.unwrap(), XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException e) {
            this.log.warn("Exception thrown during XPath evaluation: " + e);
            return false;
        }
    }
}

