/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.dom.AbstractXSLProcessingStage;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.util.ItemMetadataSupport;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ThreadSafe
public class XSLTransformationStage
extends AbstractXSLProcessingStage {
    @Override
    protected void executeTransformer(Transformer transformer, Collection<DomElementItem> itemCollection) throws StageProcessingException, TransformerConfigurationException {
        try {
            ArrayList<DomElementItem> newItems = new ArrayList<DomElementItem>();
            for (DomElementItem domItem : itemCollection) {
                transformer.setErrorListener(new AbstractXSLProcessingStage.StatusInfoAppendingErrorListener(domItem));
                Element element = (Element)domItem.unwrap();
                DOMImplementation domImpl = element.getOwnerDocument().getImplementation();
                Document newDocument = domImpl.createDocument(null, null, null);
                transformer.transform(new DOMSource(element.getOwnerDocument()), new DOMResult(newDocument));
                DomElementItem newItem = new DomElementItem(newDocument);
                ItemMetadataSupport.addToAll(newItem, domItem.getItemMetadata().values().toArray(new ItemMetadata[0]));
                newItems.add(newItem);
            }
            itemCollection.clear();
            itemCollection.addAll(newItems);
        }
        catch (TransformerException e) {
            throw new StageProcessingException("Unable to transform DOM Element", e);
        }
    }
}

