/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import org.opensaml.util.collections.CollectionSupport;
import org.opensaml.util.collections.LazySet;
import org.opensaml.util.xml.AttributeSupport;
import org.opensaml.util.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EntityRegistrationAuthorityFilterStage
extends BaseIteratingStage<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(EntityRegistrationAuthorityFilterStage.class);
    private boolean requiringRegistrationInformation;
    private Collection<String> designatedAuthorities = new LazySet();
    private boolean whitelistingAuthorities;
    private boolean removingEntitylessEntitiesDescriptor = true;

    public boolean isRequiringRegistrationInformation() {
        return this.requiringRegistrationInformation;
    }

    public synchronized void setRequiringRegistrationInformation(boolean isRequired) {
        if (this.isInitialized()) {
            return;
        }
        this.requiringRegistrationInformation = isRequired;
    }

    public Collection<String> getDesignatedRegistrationAuthorities() {
        return this.designatedAuthorities;
    }

    public synchronized void setDesignatedRegistrationAuthorities(Collection<String> authorities) {
        if (this.isInitialized()) {
            return;
        }
        this.designatedAuthorities = CollectionSupport.addNonNull(authorities, (Collection)new LazySet());
    }

    public boolean isWhitelistingRegistrationAuthorities() {
        return this.whitelistingAuthorities;
    }

    public synchronized void setWhitelistingRegistrationAuthorities(boolean whitelisting) {
        if (this.isInitialized()) {
            return;
        }
        this.whitelistingAuthorities = whitelisting;
    }

    public boolean isRemovingEntitylessEntitiesDescriptor() {
        return this.removingEntitylessEntitiesDescriptor;
    }

    public synchronized void setRemovingEntitylessEntitiesDescriptor(boolean remove) {
        if (this.isInitialized()) {
            return;
        }
        this.removingEntitylessEntitiesDescriptor = remove;
    }

    @Override
    protected boolean doExecute(DomElementItem item) {
        Element descriptor = (Element)item.unwrap();
        if (SamlMetadataSupport.isEntitiesDescriptor(descriptor)) {
            if (this.processEntitiesDescriptor(descriptor)) {
                return false;
            }
        } else if (SamlMetadataSupport.isEntityDescriptor(descriptor)) {
            return !this.filterOutDescriptor(descriptor);
        }
        return true;
    }

    protected boolean processEntitiesDescriptor(Element entitiesDescriptor) {
        Element descriptor;
        if (this.filterOutDescriptor(entitiesDescriptor)) {
            return true;
        }
        List childEntitiesDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SamlMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        Iterator descriptorItr = childEntitiesDescriptors.iterator();
        while (descriptorItr.hasNext()) {
            descriptor = (Element)descriptorItr.next();
            if (!this.processEntitiesDescriptor(descriptor)) continue;
            entitiesDescriptor.removeChild(descriptor);
            descriptorItr.remove();
        }
        List childEntityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SamlMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        descriptorItr = childEntityDescriptors.iterator();
        while (descriptorItr.hasNext()) {
            descriptor = (Element)descriptorItr.next();
            if (!this.filterOutDescriptor(descriptor)) continue;
            entitiesDescriptor.removeChild(descriptor);
            descriptorItr.remove();
        }
        return this.removingEntitylessEntitiesDescriptor && childEntitiesDescriptors.isEmpty() && childEntityDescriptors.isEmpty();
    }

    protected boolean filterOutDescriptor(Element descriptor) {
        Element registrationInfoElement = SamlMetadataSupport.getDescriptorExtensions(descriptor, new QName("urn:oasis:names:tc:SAML:metadata:rpi", "RegistrationInfo"));
        if (registrationInfoElement == null) {
            if (this.requiringRegistrationInformation) {
                this.log.debug("{} pipeline stage removing Item because it did not have required registration information extension", (Object)this.getId());
                return true;
            }
            return false;
        }
        String registrationAuthority = AttributeSupport.getAttributeValue((Element)registrationInfoElement, null, (String)"registrationAuthority");
        if (registrationAuthority == null) {
            this.log.debug("{} pipeline stage removing Item because it contained a registration info extension but no authority attribute", (Object)this.getId());
            return true;
        }
        if (this.whitelistingAuthorities && !this.designatedAuthorities.contains(registrationAuthority)) {
            this.log.debug("{} pipeline stage removing Item because its registration authority was not on the whitelist", (Object)this.getId());
            return true;
        }
        if (!this.whitelistingAuthorities && this.designatedAuthorities.contains(registrationAuthority)) {
            this.log.debug("{} pipeline stage removing Item because its registration authority was on the blacklist", (Object)this.getId());
            return true;
        }
        return false;
    }
}

