/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import org.opensaml.util.ObjectSupport;
import org.opensaml.util.collections.CollectionSupport;
import org.opensaml.util.collections.LazySet;
import org.opensaml.util.xml.DomTypeSupport;
import org.opensaml.util.xml.ElementSupport;
import org.opensaml.util.xml.QNameSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class EntityRoleFilterStage
extends BaseIteratingStage<DomElementItem> {
    public static final QName ROLE_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "RoleDescriptor");
    public static final QName IDP_SSO_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "IDPSSODescriptor");
    public static final QName SP_SSO_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "SPSSODescriptor");
    public static final QName AUTHN_AUTHORITY_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AuthnAuthorityDescriptor");
    public static final QName ATTRIBUTE_AUTHORITY_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AttributeAuthorityDescriptor");
    public static final QName PDP_DESCRIPTOR_NAME = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "PDPDescriptor");
    private final Logger log = LoggerFactory.getLogger(EntityRoleFilterStage.class);
    private Collection<QName> designatedRoles = new LazySet();
    private boolean whitelistingRoles;
    private boolean removingRolelessEntities = true;
    private boolean removingEntitylessEntitiesDescriptor = true;

    public Collection<QName> getDesignatedRoles() {
        return this.designatedRoles;
    }

    public synchronized void setDesignatedRoles(Collection<QName> roles) {
        if (this.isInitialized()) {
            return;
        }
        this.designatedRoles = CollectionSupport.addNonNull(roles, (Collection)new LazySet());
    }

    public boolean isWhitelistingRoles() {
        return this.whitelistingRoles;
    }

    public synchronized void setWhitelistingRoles(boolean whitelisting) {
        if (this.isInitialized()) {
            return;
        }
        this.whitelistingRoles = whitelisting;
    }

    public boolean isRemovingRolelessEntities() {
        return this.removingRolelessEntities;
    }

    public synchronized void setRemoveRolelessEntities(boolean remove) {
        if (this.isInitialized()) {
            return;
        }
        this.removingRolelessEntities = remove;
    }

    public boolean isRemovingEntitylessEntitiesDescriptor() {
        return this.removingEntitylessEntitiesDescriptor;
    }

    public synchronized void setRemovingEntitylessEntitiesDescriptor(boolean remove) {
        if (this.isInitialized()) {
            return;
        }
        this.removingEntitylessEntitiesDescriptor = remove;
    }

    @Override
    protected boolean doExecute(DomElementItem item) {
        Element descriptor = (Element)item.unwrap();
        return !(SamlMetadataSupport.isEntitiesDescriptor(descriptor) ? this.processEntitiesDescriptor(descriptor) : SamlMetadataSupport.isEntityDescriptor(descriptor) && this.processEntityDescriptor(descriptor));
    }

    protected boolean processEntitiesDescriptor(Element entitiesDescriptor) {
        Element descriptor;
        List childEntitiesDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SamlMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        Iterator descriptorItr = childEntitiesDescriptors.iterator();
        while (descriptorItr.hasNext()) {
            descriptor = (Element)descriptorItr.next();
            if (!this.processEntitiesDescriptor(descriptor)) continue;
            entitiesDescriptor.removeChild(descriptor);
            descriptorItr.remove();
        }
        List childEntityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SamlMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        descriptorItr = childEntityDescriptors.iterator();
        while (descriptorItr.hasNext()) {
            descriptor = (Element)descriptorItr.next();
            if (!this.processEntityDescriptor(descriptor)) continue;
            entitiesDescriptor.removeChild(descriptor);
            descriptorItr.remove();
        }
        return this.removingEntitylessEntitiesDescriptor && childEntitiesDescriptors.isEmpty() && childEntityDescriptors.isEmpty();
    }

    protected boolean processEntityDescriptor(Element entityDescriptor) {
        if (this.designatedRoles.isEmpty()) {
            return false;
        }
        String entityId = entityDescriptor.getAttributeNS(null, "entityID");
        this.log.debug("{} pipeline stage filtering roles from EntityDescriptor {}", (Object)this.getId(), (Object)entityId);
        List<Element> roles = this.getFilteredRoles(entityId, entityDescriptor);
        return this.removingRolelessEntities && roles.isEmpty();
    }

    protected List<Element> getFilteredRoles(String entityId, Element entityDescriptor) {
        List childElements = ElementSupport.getChildElements((Node)entityDescriptor);
        Iterator childItr = childElements.iterator();
        while (childItr.hasNext()) {
            Element child = (Element)childItr.next();
            QName childQName = QNameSupport.getNodeQName((Node)child);
            QName roleIdentifier = null;
            if (ObjectSupport.equals((Object)childQName, (Object)ROLE_DESCRIPTOR_NAME)) {
                roleIdentifier = DomTypeSupport.getXSIType((Element)child);
            } else if (ObjectSupport.equalsAny((Object)childQName, (Object[])new Object[]{IDP_SSO_DESCRIPTOR_NAME, SP_SSO_DESCRIPTOR_NAME, AUTHN_AUTHORITY_DESCRIPTOR_NAME, ATTRIBUTE_AUTHORITY_DESCRIPTOR_NAME, PDP_DESCRIPTOR_NAME})) {
                roleIdentifier = childQName;
            } else {
                childItr.remove();
                continue;
            }
            boolean isDesignatedRole = this.designatedRoles.contains(roleIdentifier);
            if (roleIdentifier == null) continue;
            if (this.isWhitelistingRoles() && !isDesignatedRole || !this.isWhitelistingRoles() && isDesignatedRole) {
                this.log.debug("{} pipeline stage removing role {} from EntityDescriptor {}", new Object[]{this.getId(), roleIdentifier, entityId});
                entityDescriptor.removeChild(child);
                childItr.remove();
                continue;
            }
            this.log.debug("{} pipeline did not remove role {} from EntityDescriptor {}", new Object[]{this.getId(), roleIdentifier, entityId});
        }
        return childElements;
    }
}

