/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.Assert;
import org.opensaml.util.xml.AttributeSupport;
import org.opensaml.util.xml.ElementSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PullUpCacheDurationStage
extends BaseIteratingStage<DomElementItem> {
    private long minCacheDuration;
    private long maxCacheDuration = Long.MAX_VALUE;

    public long getMinimumCacheDuration() {
        return this.minCacheDuration;
    }

    public synchronized void setMinimumCacheDuration(long duration) {
        if (this.isInitialized()) {
            return;
        }
        this.minCacheDuration = duration < 0L ? 0L : duration;
    }

    public long getMaximumCacheDuration() {
        return this.maxCacheDuration;
    }

    public synchronized void setMaximumCacheDuration(long duration) {
        if (this.isInitialized()) {
            return;
        }
        Assert.isGreaterThan((long)0L, (long)duration, (String)"Maximum cache duration must be greater than 0");
        this.maxCacheDuration = duration;
    }

    @Override
    protected boolean doExecute(DomElementItem item) throws StageProcessingException {
        Element descriptor = (Element)item.unwrap();
        Long cacheDuration = this.getShortestCacheDuration(descriptor);
        this.setCacheDuration(descriptor, cacheDuration);
        return true;
    }

    protected Long getShortestCacheDuration(Element descriptor) {
        Long shortestCacheDuration = null;
        if (!SamlMetadataSupport.isEntitiesDescriptor(descriptor) && !SamlMetadataSupport.isEntityDescriptor(descriptor)) {
            return shortestCacheDuration;
        }
        Long cacheDuration = null;
        List entitiesDescriptors = ElementSupport.getChildElements((Node)descriptor, (QName)SamlMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        for (Element entitiesDescriptor : entitiesDescriptors) {
            cacheDuration = this.getShortestCacheDuration(entitiesDescriptor);
            if (cacheDuration == null || shortestCacheDuration != null && cacheDuration >= shortestCacheDuration) continue;
            shortestCacheDuration = cacheDuration;
        }
        List entityDescriptors = ElementSupport.getChildElements((Node)descriptor, (QName)SamlMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        for (Element entityDescriptor : entityDescriptors) {
            cacheDuration = this.getShortestCacheDuration(entityDescriptor);
            if (cacheDuration == null || shortestCacheDuration != null && cacheDuration >= shortestCacheDuration) continue;
            shortestCacheDuration = cacheDuration;
        }
        Attr cacheDurationAttr = AttributeSupport.getAttribute((Element)descriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
        if (cacheDurationAttr != null) {
            cacheDuration = AttributeSupport.getDurationAttributeValueAsLong((Attr)cacheDurationAttr);
            if (cacheDuration != null && (shortestCacheDuration == null || cacheDuration < shortestCacheDuration)) {
                shortestCacheDuration = cacheDuration;
            }
            descriptor.removeAttributeNode(cacheDurationAttr);
        }
        return shortestCacheDuration;
    }

    protected void setCacheDuration(Element descriptor, Long cacheDuration) {
        if (cacheDuration == null || cacheDuration <= 0L) {
            return;
        }
        if (cacheDuration < this.minCacheDuration) {
            AttributeSupport.appendDurationAttribute((Element)descriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (long)this.minCacheDuration);
        } else if (cacheDuration > this.maxCacheDuration) {
            AttributeSupport.appendDurationAttribute((Element)descriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (long)this.maxCacheDuration);
        } else {
            AttributeSupport.appendDurationAttribute((Element)descriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (long)cacheDuration);
        }
    }
}

