/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.Assert;
import org.opensaml.util.xml.AttributeSupport;
import org.opensaml.util.xml.ElementSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PullUpValidUntilStage
extends BaseIteratingStage<DomElementItem> {
    private long minValidityDuration;
    private long maxValidityDuration = Long.MAX_VALUE;

    public long getMinimumValidityDuration() {
        return this.minValidityDuration;
    }

    public synchronized void setMinimumValidityDuration(long duration) {
        if (this.isInitialized()) {
            return;
        }
        this.minValidityDuration = duration < 0L ? 0L : duration;
    }

    public long getMaximumValidityDuration() {
        return this.maxValidityDuration;
    }

    public synchronized void setMaximumValidityDuration(long duration) {
        if (this.isInitialized()) {
            return;
        }
        Assert.isGreaterThan((long)0L, (long)duration, (String)"Maximum validity duration must be greater than 0");
        this.maxValidityDuration = duration;
    }

    @Override
    protected boolean doExecute(DomElementItem item) throws StageProcessingException {
        Element descriptor = (Element)item.unwrap();
        Long nearestValidUntil = this.getNearestValidUntil(descriptor);
        this.setValidUntil(descriptor, nearestValidUntil);
        return true;
    }

    protected Long getNearestValidUntil(Element descriptor) {
        Long validUntil;
        Long nearestValidUntil = null;
        if (!SamlMetadataSupport.isEntitiesDescriptor(descriptor) && !SamlMetadataSupport.isEntityDescriptor(descriptor)) {
            return nearestValidUntil;
        }
        List entitiesDescriptors = ElementSupport.getChildElements((Node)descriptor, (QName)SamlMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        for (Element entitiesDescriptor : entitiesDescriptors) {
            validUntil = this.getNearestValidUntil(entitiesDescriptor);
            if (validUntil == null || nearestValidUntil != null && validUntil >= nearestValidUntil) continue;
            nearestValidUntil = validUntil;
        }
        List entityDescriptors = ElementSupport.getChildElements((Node)descriptor, (QName)SamlMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        for (Element entityDescriptor : entityDescriptors) {
            validUntil = this.getNearestValidUntil(entityDescriptor);
            if (validUntil == null || nearestValidUntil != null && validUntil >= nearestValidUntil) continue;
            nearestValidUntil = validUntil;
        }
        Attr validUntilAttr = descriptor.getAttributeNodeNS(null, SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME.getLocalPart());
        if (validUntilAttr != null) {
            validUntil = AttributeSupport.getDateTimeAttributeAsLong((Attr)validUntilAttr);
            if (validUntil != null && (nearestValidUntil == null || validUntil < nearestValidUntil)) {
                nearestValidUntil = validUntil;
            }
            descriptor.removeAttributeNode(validUntilAttr);
        }
        return nearestValidUntil;
    }

    protected void setValidUntil(Element descriptor, Long validUntil) {
        if (validUntil == null) {
            return;
        }
        long now = System.currentTimeMillis();
        long minValidUntil = now + this.minValidityDuration;
        long maxValidUntil = now + this.maxValidityDuration;
        if (maxValidUntil < 0L) {
            maxValidUntil = Long.MAX_VALUE;
        }
        long boundedValidUntil = validUntil < minValidUntil ? minValidUntil : (validUntil > maxValidUntil ? maxValidUntil : validUntil);
        AttributeSupport.appendDateTimeAttribute((Element)descriptor, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME, (long)boundedValidUntil);
    }
}

