/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.List;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.RemoveContactPersonStage;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RemoveOrganizationStage
extends BaseIteratingStage<DomElementItem> {
    private final Logger log = LoggerFactory.getLogger(RemoveContactPersonStage.class);

    @Override
    protected boolean doExecute(DomElementItem item) throws StageProcessingException {
        Element descriptor = (Element)item.unwrap();
        if (SamlMetadataSupport.isEntitiesDescriptor(descriptor)) {
            this.processEntitiesDescriptor(descriptor);
        } else if (SamlMetadataSupport.isEntityDescriptor(descriptor)) {
            this.processEntityDescriptor(descriptor);
        }
        return true;
    }

    protected void processEntitiesDescriptor(Element entitiesDescriptor) {
        List children = ElementSupport.getChildElements((Node)entitiesDescriptor);
        for (Element child : children) {
            if (SamlMetadataSupport.isEntitiesDescriptor(child)) {
                this.processEntitiesDescriptor(child);
                continue;
            }
            if (!SamlMetadataSupport.isEntityDescriptor(child)) continue;
            this.processEntityDescriptor(child);
        }
    }

    protected void processEntityDescriptor(Element entityDescriptor) {
        String entityId = entityDescriptor.getAttributeNS(null, "entityID");
        List organizations = ElementSupport.getChildElementsByTagNameNS((Node)entityDescriptor, (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"Organization");
        if (!organizations.isEmpty()) {
            this.log.debug("{} pipeline stage filtering Organization from EntityDescriptor {}", (Object)this.getId(), (Object)entityId);
            for (Element organization : organizations) {
                entityDescriptor.removeChild(organization);
            }
        }
    }
}

