/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.xml.AttributeSupport;
import org.w3c.dom.Element;

public class SetCacheDurationStage
extends BaseIteratingStage<DomElementItem> {
    private long cacheDuration;

    public long getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(long duration) {
        if (this.isInitialized()) {
            return;
        }
        this.cacheDuration = duration;
    }

    @Override
    protected boolean doExecute(DomElementItem item) throws StageProcessingException {
        Element descriptor = (Element)item.unwrap();
        if (SamlMetadataSupport.isEntitiesDescriptor(descriptor) || SamlMetadataSupport.isEntityDescriptor(descriptor)) {
            AttributeSupport.removeAttribute((Element)descriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
            AttributeSupport.appendDurationAttribute((Element)descriptor, (QName)SamlMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (long)this.cacheDuration);
        }
        return true;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.cacheDuration <= 0L) {
            throw new ComponentInitializationException("Cache duration must be greater than 0");
        }
    }
}

