/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.xml.AttributeSupport;
import org.w3c.dom.Element;

public class SetValidUntilStage
extends BaseIteratingStage<DomElementItem> {
    private long validityDuration;

    public long getValidityDuration() {
        return this.validityDuration;
    }

    public synchronized void setValidityDuration(long duration) {
        if (this.isInitialized()) {
            return;
        }
        this.validityDuration = duration;
    }

    @Override
    protected boolean doExecute(DomElementItem item) throws StageProcessingException {
        Element descriptor = (Element)item.unwrap();
        if (SamlMetadataSupport.isEntitiesDescriptor(descriptor) || SamlMetadataSupport.isEntityDescriptor(descriptor)) {
            AttributeSupport.removeAttribute((Element)descriptor, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME);
            AttributeSupport.appendDateTimeAttribute((Element)descriptor, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME, (long)(System.currentTimeMillis() + this.validityDuration));
        }
        return true;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.validityDuration <= 0L) {
            throw new ComponentInitializationException("Validity duration must be greater than 0");
        }
    }
}

