/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.xml.namespace.QName;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.dom.DomElementItem;
import net.shibboleth.metadata.dom.saml.SamlMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseIteratingStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.xml.AttributeSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ValidateValidUntilStage
extends BaseIteratingStage<DomElementItem> {
    private boolean requireValidUntil = true;
    private long maxValidityInterval = 604800000L;

    public boolean isRequireValidUntil() {
        return this.requireValidUntil;
    }

    public synchronized void setRequireValidUntil(boolean isRequired) {
        if (this.isInitialized()) {
            return;
        }
        this.requireValidUntil = isRequired;
    }

    public long getMaxValidityInterval() {
        return this.maxValidityInterval;
    }

    public synchronized void setMaxValidityInterval(long interval) {
        if (this.isInitialized()) {
            return;
        }
        this.maxValidityInterval = interval;
    }

    @Override
    protected boolean doExecute(DomElementItem item) throws StageProcessingException {
        Element element = (Element)item.unwrap();
        if (!SamlMetadataSupport.isEntitiesDescriptor(element) && !SamlMetadataSupport.isEntityDescriptor(element)) {
            return true;
        }
        Long validUntil = AttributeSupport.getDateTimeAttributeAsLong((Attr)AttributeSupport.getAttribute((Element)element, (QName)SamlMetadataSupport.VALID_UNTIL_ATTIB_NAME));
        if (validUntil == null) {
            if (this.requireValidUntil) {
                item.getItemMetadata().put(new ErrorStatus(this.getId(), "Item does not include a validUntil attribute"));
            }
        } else {
            long lowerBound = System.currentTimeMillis();
            if (validUntil < lowerBound) {
                item.getItemMetadata().put(new ErrorStatus(this.getId(), "Item has a validUntil prior to the current time"));
            }
            if (this.maxValidityInterval > 0L) {
                long upperBound = lowerBound + this.maxValidityInterval;
                if (validUntil > upperBound) {
                    item.getItemMetadata().put(new ErrorStatus(this.getId(), "Item has validUntil larger than the maximum validity interval"));
                }
            }
        }
        return true;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.maxValidityInterval < 0L) {
            throw new ComponentInitializationException("Max validity interval must be greater than or equal to 0");
        }
    }
}

