/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.pipeline.Component;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.util.Assert;
import org.opensaml.util.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractComponent
implements Component {
    private final Logger log = LoggerFactory.getLogger(AbstractComponent.class);
    private String id;
    private DateTime initInstant;

    @Override
    public String getId() {
        return this.id;
    }

    public synchronized void setId(String componentId) {
        if (this.isInitialized()) {
            return;
        }
        this.id = StringSupport.trimOrNull((String)componentId);
        Assert.isNotNull((Object)this.id, (String)"Component ID may not be null nor empty");
    }

    @Override
    public final DateTime getInitializationInstant() {
        return this.initInstant;
    }

    @Override
    public final synchronized void initialize() throws ComponentInitializationException {
        if (this.isInitialized()) {
            throw new IllegalStateException("Pipeline component already initialized");
        }
        if (this.id == null) {
            throw new ComponentInitializationException("Pipeline component may not have a null or empty ID");
        }
        this.log.debug("Initializing pipeline component {}", (Object)this.getId());
        this.doInitialize();
        this.initInstant = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        this.log.debug("Pipeline component {} initialized", (Object)this.getId());
    }

    @Override
    public final boolean isInitialized() {
        return this.initInstant != null;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof AbstractComponent) {
            AbstractComponent otherComponent = (AbstractComponent)obj;
            return this.id.equals(otherComponent.getId());
        }
        return false;
    }

    protected void doInitialize() throws ComponentInitializationException {
    }
}

