/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.shibboleth.metadata.FirstItemIdItemIdentificationStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemIdentificationStrategy;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.Assert;
import org.opensaml.util.collections.CollectionSupport;
import org.opensaml.util.collections.LazyList;

public abstract class AbstractItemMetadataSelectionStage
extends BaseStage<Item<?>> {
    private Collection<Class<ItemMetadata>> selectionRequirements = Collections.emptyList();
    private ItemIdentificationStrategy identifierStrategy = new FirstItemIdItemIdentificationStrategy();

    public Collection<Class<ItemMetadata>> getSelectionRequirements() {
        return this.selectionRequirements;
    }

    public synchronized void setSelectionRequirements(Collection<Class<ItemMetadata>> requirements) {
        if (this.isInitialized()) {
            return;
        }
        this.selectionRequirements = Collections.unmodifiableList((List)CollectionSupport.addNonNull(requirements, (Collection)new LazyList()));
    }

    public ItemIdentificationStrategy getItemIdentifierStrategy() {
        return this.identifierStrategy;
    }

    public synchronized void setIdentifierStrategy(ItemIdentificationStrategy strategy) {
        if (this.isInitialized()) {
            return;
        }
        this.identifierStrategy = (ItemIdentificationStrategy)Assert.isNotNull((Object)strategy, (String)"Item identification strategy can not be null");
    }

    @Override
    protected void doExecute(Collection<Item<?>> itemCollection) throws StageProcessingException {
        ArrayList collectionCopy = new ArrayList(itemCollection);
        for (Item<?> item : collectionCopy) {
            HashMap<Class<? extends ItemMetadata>, List<? extends ItemMetadata>> matchingMetadata = new HashMap<Class<? extends ItemMetadata>, List<? extends ItemMetadata>>();
            for (Class<ItemMetadata> infoClass : this.selectionRequirements) {
                if (!item.getItemMetadata().containsKey(infoClass)) continue;
                matchingMetadata.put(infoClass, item.getItemMetadata().get(infoClass));
            }
            if (matchingMetadata.isEmpty()) continue;
            this.doExecute(itemCollection, item, matchingMetadata);
        }
    }

    protected abstract void doExecute(Collection<Item<?>> var1, Item<?> var2, Map<Class<? extends ItemMetadata>, List<? extends ItemMetadata>> var3) throws StageProcessingException;
}

