/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.AbstractComponent;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.Stage;
import net.shibboleth.metadata.pipeline.StageProcessingException;

public class CompositeStage<ItemType extends Item<?>>
extends AbstractComponent
implements Stage<ItemType> {
    private List<Stage<ItemType>> composedStages;

    public List<Stage<ItemType>> getComposedStages() {
        return this.composedStages;
    }

    public synchronized void setComposedStages(List<Stage<ItemType>> stages) {
        if (this.isInitialized()) {
            return;
        }
        ArrayList<Stage<ItemType>> newStages = new ArrayList<Stage<ItemType>>();
        for (Stage<ItemType> stage : stages) {
            if (stage == null) continue;
            newStages.add(stage);
        }
        this.composedStages = Collections.unmodifiableList(newStages);
    }

    @Override
    public void execute(Collection<ItemType> itemCollection) throws StageProcessingException {
        for (Stage<ItemType> stage : this.composedStages) {
            stage.execute(itemCollection);
        }
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.composedStages == null || this.composedStages.isEmpty()) {
            this.composedStages = Collections.emptyList();
        }
    }
}

