/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.Collection;
import java.util.concurrent.Callable;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.PipelineProcessingException;
import org.opensaml.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineCallable
implements Callable<Collection<? extends Item>> {
    private final Logger log = LoggerFactory.getLogger(PipelineCallable.class);
    private Pipeline pipeline;
    private Collection<? extends Item> itemCollection;

    public PipelineCallable(Pipeline invokedPipeline, Collection<? extends Item> items) {
        Assert.isNotNull((Object)invokedPipeline, (String)"To-be-invoked pipeline can not be null");
        Assert.isTrue((boolean)invokedPipeline.isInitialized(), (String)"To-be-invoked pipeline must be initialized");
        this.pipeline = invokedPipeline;
        Assert.isNotNull(items, (String)"Item collection can not be null");
        this.itemCollection = items;
    }

    @Override
    public Collection<? extends Item> call() {
        try {
            this.log.debug("Executing pipeline {} on an item collection containing {} items", (Object)this.pipeline.getId(), (Object)this.itemCollection.size());
            this.pipeline.execute(this.itemCollection);
            return this.itemCollection;
        }
        catch (PipelineProcessingException e) {
            this.log.error("Execution of pipeline {} failed.", (Object)this.pipeline.getId(), (Object)e);
            return null;
        }
    }
}

