/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemCollectionFactory;
import net.shibboleth.metadata.ItemSelectionStrategy;
import net.shibboleth.metadata.SimpleItemCollectionFactory;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.PipelineCallable;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineDemultiplexerStage<ItemType extends Item<?>>
extends BaseStage<ItemType> {
    private final Logger log = LoggerFactory.getLogger(PipelineDemultiplexerStage.class);
    private ExecutorService executorService;
    private boolean waitingForPipelines;
    private ItemCollectionFactory<ItemType> collectionFactory;
    private List<Pair<Pipeline<ItemType>, ItemSelectionStrategy<ItemType>>> pipelineAndStrategies;

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public synchronized void setExecutorService(ExecutorService service) {
        if (this.isInitialized()) {
            return;
        }
        this.executorService = service;
    }

    public boolean isWaitingForPipelines() {
        return this.waitingForPipelines;
    }

    public synchronized void setWaitingForPipelines(boolean isWaiting) {
        if (this.isInitialized()) {
            return;
        }
        this.waitingForPipelines = isWaiting;
    }

    public ItemCollectionFactory getCollectionFactory() {
        return this.collectionFactory;
    }

    public synchronized void setCollectionFactory(ItemCollectionFactory<ItemType> factory) {
        if (this.isInitialized()) {
            return;
        }
        this.collectionFactory = factory;
    }

    public List<Pair<Pipeline<ItemType>, ItemSelectionStrategy<ItemType>>> getPipelineAndSelectionStrategies() {
        return this.pipelineAndStrategies;
    }

    public synchronized void setPipelineAndSelectionStrategies(List<Pair<Pipeline<ItemType>, ItemSelectionStrategy<ItemType>>> pass) {
        if (this.isInitialized()) {
            return;
        }
        this.pipelineAndStrategies = pass;
    }

    @Override
    protected void doExecute(Collection<ItemType> itemCollection) throws StageProcessingException {
        ArrayList<Future<Collection<? extends Item>>> pipelineFutures = new ArrayList<Future<Collection<? extends Item>>>();
        for (Pair<Pipeline<ItemType>, ItemSelectionStrategy<ItemType>> pair : this.pipelineAndStrategies) {
            Pipeline pipeline = (Pipeline)pair.getFirst();
            ItemSelectionStrategy selectionStrategy = (ItemSelectionStrategy)pair.getSecond();
            Collection<ItemType> selectedItems = this.collectionFactory.newCollection();
            for (Item item : itemCollection) {
                if (!selectionStrategy.isSelectedItem(item)) continue;
                selectedItems.add(item.copy());
            }
            pipelineFutures.add(this.executorService.submit(new PipelineCallable(pipeline, selectedItems)));
        }
        if (this.isWaitingForPipelines()) {
            for (Future future : pipelineFutures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    this.log.error("Pipeline threw an unexpected exception", (Throwable)e);
                }
                catch (InterruptedException e) {
                    this.log.error("Execution service was interrupted", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.executorService == null) {
            this.log.debug("No ExecutorService specified, creating a fixed thread pool service with 6 threads");
            this.executorService = Executors.newFixedThreadPool(6);
        }
        if (this.collectionFactory == null) {
            this.log.debug("No collection factory specified, using {}", (Object)SimpleItemCollectionFactory.class.getName());
            this.collectionFactory = new SimpleItemCollectionFactory();
        }
        if (this.pipelineAndStrategies == null || this.pipelineAndStrategies.isEmpty()) {
            throw new ComponentInitializationException("Pipeline and selection strategy collection can not be null or empty");
        }
        for (Pair<Pipeline<ItemType>, ItemSelectionStrategy<ItemType>> pipelineAndStrategy : this.pipelineAndStrategies) {
            Pipeline pipeline = (Pipeline)pipelineAndStrategy.getFirst();
            if (pipeline == null) {
                throw new ComponentInitializationException("Pipeline of pipeline and selection strategy collection entry can not be null");
            }
            if (!pipeline.isInitialized()) {
                pipeline.initialize();
            }
            if (pipelineAndStrategy.getSecond() != null) continue;
            throw new ComponentInitializationException("Item selection strategy of pipeline and selection strategy collection entry can not be null");
        }
    }
}

