/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.CollectionMergeStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemCollectionFactory;
import net.shibboleth.metadata.SimpleCollectionMergeStrategy;
import net.shibboleth.metadata.SimpleItemCollectionFactory;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.PipelineCallable;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.Assert;
import org.opensaml.util.collections.CollectionSupport;
import org.opensaml.util.collections.LazyList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PipelineMergeStage
extends BaseStage<Item<?>> {
    private final Logger log = LoggerFactory.getLogger(PipelineMergeStage.class);
    private ExecutorService executorService;
    private ItemCollectionFactory collectionFactory;
    private CollectionMergeStrategy mergeStrategy;
    private List<Pipeline<Item<?>>> mergedPipelines = new LazyList();

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public synchronized void setExecutorService(ExecutorService service) {
        if (this.isInitialized()) {
            return;
        }
        this.executorService = service;
    }

    public List<Pipeline<Item<?>>> getMergedPipelines() {
        return this.mergedPipelines;
    }

    public synchronized void setMergedPipelines(List<Pipeline<Item<?>>> pipelines) {
        if (this.isInitialized()) {
            return;
        }
        this.mergedPipelines = Collections.unmodifiableList((List)CollectionSupport.addNonNull(pipelines, (Collection)new LazyList()));
    }

    public ItemCollectionFactory getCollectionFactory() {
        return this.collectionFactory;
    }

    public synchronized void setCollectionFactory(ItemCollectionFactory factory) {
        if (this.isInitialized()) {
            return;
        }
        Assert.isNotNull((Object)factory, (String)"Collection factory may not be null");
        this.collectionFactory = factory;
    }

    public CollectionMergeStrategy getCollectionMergeStrategy() {
        return this.mergeStrategy;
    }

    public synchronized void setCollectionMergeStrategy(CollectionMergeStrategy strategy) {
        if (this.isInitialized()) {
            return;
        }
        this.mergeStrategy = strategy;
    }

    @Override
    protected void doExecute(Collection<Item<?>> itemCollection) throws StageProcessingException {
        ArrayList<Future<Collection<? extends Item>>> pipelineResultFutures = new ArrayList<Future<Collection<? extends Item>>>();
        for (Pipeline<Item<?>> pipeline : this.mergedPipelines) {
            pipelineResultFutures.add(this.executorService.submit(new PipelineCallable(pipeline, this.collectionFactory.newCollection())));
        }
        ArrayList pipelineResults = new ArrayList();
        for (Future future : pipelineResultFutures) {
            try {
                pipelineResults.add(future.get());
            }
            catch (ExecutionException e) {
                throw new StageProcessingException(e);
            }
            catch (InterruptedException e) {
                throw new StageProcessingException(e);
            }
        }
        this.mergeStrategy.mergeCollection(itemCollection, pipelineResults.toArray(new Collection[pipelineResults.size()]));
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.executorService == null) {
            this.log.debug("No ExecutorService specified, creating a fixed thread pool service with 6 threads");
            this.executorService = Executors.newFixedThreadPool(6);
        }
        if (this.collectionFactory == null) {
            this.log.debug("No collection factory specified, using {}", (Object)SimpleItemCollectionFactory.class.getName());
            this.collectionFactory = new SimpleItemCollectionFactory();
        }
        if (this.mergeStrategy == null) {
            this.log.debug("No collection merge strategy specified, using {}", (Object)SimpleCollectionMergeStrategy.class.getName());
            this.mergeStrategy = new SimpleCollectionMergeStrategy();
        }
        for (Pipeline<Item<?>> pipeline : this.mergedPipelines) {
            if (pipeline.isInitialized()) continue;
            pipeline.initialize();
        }
    }
}

