/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.opensaml.util.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ScriptletStage
extends BaseStage<Item<?>> {
    public static final String ITEM = "item";
    private final Logger log = LoggerFactory.getLogger(ScriptletStage.class);
    private String scriptLanguage = "ecmascript";
    private File scriptFile;
    private ScriptEngine scriptEngine;
    private CompiledScript compiledScript;

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public synchronized void setScriptLanguage(String language) {
        if (this.isInitialized()) {
            return;
        }
        this.scriptLanguage = StringSupport.trimOrNull((String)language);
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public synchronized void setScriptFile(File file) {
        if (this.isInitialized()) {
            return;
        }
        this.scriptFile = file;
    }

    @Override
    protected void doExecute(Collection<Item<?>> itemCollection) throws StageProcessingException {
        Bindings bindings = this.scriptEngine.createBindings();
        bindings.put(ITEM, (Object)itemCollection);
        try {
            if (this.compiledScript != null) {
                this.compiledScript.eval(bindings);
            } else {
                this.scriptEngine.eval((Reader)new FileReader(this.scriptFile), bindings);
            }
        }
        catch (ScriptException e) {
            String errMsg = this.getId() + " pipeline stage unable to execut script";
            this.log.error(errMsg, (Throwable)e);
            throw new StageProcessingException(errMsg, e);
        }
        catch (FileNotFoundException e) {
            String errMsg = this.getId() + " pipeline stage unable to read script file " + this.scriptFile.getPath();
            this.log.error(errMsg, (Throwable)e);
            throw new StageProcessingException(errMsg, e);
        }
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.scriptLanguage == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", ScriptLanguage may not be null");
        }
        if (this.scriptFile == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", Source may not be null");
        }
        if (!this.scriptFile.exists() || !this.scriptFile.canRead()) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", source file/directory " + this.scriptFile.getPath() + " can not be read");
        }
        ScriptEngineManager sem = new ScriptEngineManager();
        this.scriptEngine = sem.getEngineByName(this.scriptLanguage);
        try {
            if (this.scriptEngine != null && this.scriptEngine instanceof Compilable) {
                this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(new FileReader(this.scriptFile));
            }
        }
        catch (ScriptException e) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", unable to compile script", e);
        }
        catch (IOException e) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", unable to read script file", e);
        }
    }
}

