/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemSerializer;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.StageProcessingException;

public class SerializationStage<ItemType extends Item<?>>
extends BaseStage<ItemType> {
    private File outputFile;
    private boolean overwritingExistingOutputFile = true;
    private ItemSerializer<ItemType> serializer;

    public File getOutputFile() {
        return this.outputFile;
    }

    public synchronized void setOutputFile(File file) {
        if (this.isInitialized()) {
            return;
        }
        this.outputFile = file;
    }

    public boolean isOverwritingExistingOutputFile() {
        return this.overwritingExistingOutputFile;
    }

    public synchronized void setOverwritingExistingOutputFile(boolean isOverwriting) {
        if (this.isInitialized()) {
            return;
        }
        this.overwritingExistingOutputFile = isOverwriting;
    }

    public ItemSerializer<ItemType> getSerializer() {
        return this.serializer;
    }

    public synchronized void setSerializer(ItemSerializer<ItemType> itemSerializer) {
        if (this.isInitialized()) {
            return;
        }
        this.serializer = itemSerializer;
    }

    @Override
    protected void doExecute(Collection<ItemType> itemCollection) throws StageProcessingException {
        try {
            this.serializer.serialize(itemCollection, new FileOutputStream(this.outputFile));
        }
        catch (IOException e) {
            throw new StageProcessingException("Error write to output file " + this.outputFile.getAbsolutePath(), e);
        }
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.outputFile == null) {
            throw new ComponentInitializationException("Output file can not be null");
        }
        if (this.serializer == null) {
            throw new ComponentInitializationException("Item serializer can not be null");
        }
        if (this.outputFile.exists() && !this.overwritingExistingOutputFile) {
            throw new ComponentInitializationException("Output file " + this.outputFile.getAbsolutePath() + " exist and stage is configured not to overwrite the file");
        }
    }
}

