/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.AbstractComponent;
import net.shibboleth.metadata.pipeline.ComponentInfo;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.PipelineProcessingException;
import net.shibboleth.metadata.pipeline.Stage;
import net.shibboleth.metadata.util.ItemMetadataSupport;
import org.opensaml.util.collections.CollectionSupport;
import org.opensaml.util.collections.LazyList;

@ThreadSafe
public class SimplePipeline<ItemType extends Item<?>>
extends AbstractComponent
implements Pipeline<ItemType> {
    private List<Stage<ItemType>> pipelineStages = Collections.emptyList();

    @Override
    public List<Stage<ItemType>> getStages() {
        return this.pipelineStages;
    }

    public synchronized void setStages(List<Stage<ItemType>> stages) {
        if (this.isInitialized()) {
            return;
        }
        this.pipelineStages = Collections.unmodifiableList((List)CollectionSupport.addNonNull(stages, (Collection)new LazyList()));
    }

    @Override
    public void execute(Collection<ItemType> itemCollection) throws PipelineProcessingException {
        ComponentInfo compInfo = new ComponentInfo(this);
        for (Stage<ItemType> stage : this.pipelineStages) {
            stage.execute(itemCollection);
        }
        compInfo.setCompleteInstant();
        ItemMetadataSupport.addToAll(itemCollection, compInfo);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if (this.pipelineStages == null || this.pipelineStages.isEmpty()) {
            this.pipelineStages = Collections.emptyList();
        }
        for (Stage<ItemType> stage : this.pipelineStages) {
            if (stage.isInitialized()) continue;
            stage.initialize();
        }
    }
}

