/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.shibboleth.metadata.CollectionMergeStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemCollectionFactory;
import net.shibboleth.metadata.ItemSelectionStrategy;
import net.shibboleth.metadata.SimpleCollectionMergeStrategy;
import net.shibboleth.metadata.SimpleItemCollectionFactory;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.PipelineCallable;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitMergeStage<ItemType extends Item<?>>
extends BaseStage<ItemType> {
    private final Logger log = LoggerFactory.getLogger(SplitMergeStage.class);
    private ExecutorService executorService;
    private ItemCollectionFactory<ItemType> collectionFactory;
    private ItemSelectionStrategy<ItemType> selectionStrategy;
    private Pipeline<ItemType> selectedItemPipeline;
    private Pipeline<ItemType> nonselectedItemPipeline;
    private CollectionMergeStrategy mergeStrategy;

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public synchronized void setExecutorService(ExecutorService service) {
        if (this.isInitialized()) {
            return;
        }
        this.executorService = service;
    }

    public ItemCollectionFactory getCollectionFactory() {
        return this.collectionFactory;
    }

    public synchronized void setCollectionFactory(ItemCollectionFactory<ItemType> factory) {
        if (this.isInitialized()) {
            return;
        }
        this.collectionFactory = factory;
    }

    public ItemSelectionStrategy<ItemType> getSelectionStrategy() {
        return this.selectionStrategy;
    }

    public synchronized void setSelectionStrategy(ItemSelectionStrategy<ItemType> strategy) {
        if (this.isInitialized()) {
            return;
        }
        this.selectionStrategy = strategy;
    }

    public Pipeline<ItemType> getSelectedItemPipeline() {
        return this.selectedItemPipeline;
    }

    public synchronized void setSelectedItemPipeline(Pipeline<ItemType> pipeline) {
        if (this.isInitialized()) {
            return;
        }
        this.selectedItemPipeline = pipeline;
    }

    public Pipeline<ItemType> getNonselectedItemPipeline() {
        return this.nonselectedItemPipeline;
    }

    public synchronized void setNonselectedItemPipeline(Pipeline<ItemType> pipeline) {
        if (this.isInitialized()) {
            return;
        }
        this.nonselectedItemPipeline = pipeline;
    }

    public CollectionMergeStrategy getCollectionMergeStrategy() {
        return this.mergeStrategy;
    }

    public synchronized void setCollectionMergeStrategy(CollectionMergeStrategy strategy) {
        if (this.isInitialized()) {
            return;
        }
        this.mergeStrategy = strategy;
    }

    @Override
    protected void doExecute(Collection<ItemType> itemCollection) throws StageProcessingException {
        Collection<ItemType> selectedItems = this.collectionFactory.newCollection();
        Collection<ItemType> nonselectedItems = this.collectionFactory.newCollection();
        for (Item<?> item : itemCollection) {
            if (item == null) continue;
            if (this.selectionStrategy.isSelectedItem(item)) {
                selectedItems.add(item.copy());
                continue;
            }
            nonselectedItems.add(item.copy());
        }
        Future<Collection<Item>> selectedItemFuture = this.executePipeline(this.selectedItemPipeline, selectedItems);
        Future<Collection<Item>> future = this.executePipeline(this.nonselectedItemPipeline, nonselectedItems);
        ArrayList<Collection<Item<Object>>> pipelineResults = new ArrayList<Collection<Item<Object>>>();
        try {
            if (selectedItemFuture != null) {
                pipelineResults.add(selectedItemFuture.get());
            } else {
                pipelineResults.add(selectedItems);
            }
            if (future != null) {
                pipelineResults.add(future.get());
            } else {
                pipelineResults.add(nonselectedItems);
            }
        }
        catch (ExecutionException e) {
            this.log.error("Pipeline threw an unexpected exception", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.log.error("Execution service was interrupted", (Throwable)e);
        }
        itemCollection.clear();
        this.mergeStrategy.mergeCollection(itemCollection, pipelineResults.toArray(new Collection[pipelineResults.size()]));
    }

    protected Future<Collection<? extends Item>> executePipeline(Pipeline<ItemType> pipeline, Collection<ItemType> items) {
        if (pipeline == null) {
            return null;
        }
        PipelineCallable callable = new PipelineCallable(pipeline, items);
        return this.executorService.submit(callable);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.executorService == null) {
            this.log.debug("No ExecutorService specified, creating a fixed thread pool service with 6 threads");
            this.executorService = Executors.newFixedThreadPool(6);
        }
        if (this.collectionFactory == null) {
            this.log.debug("No collection factory specified, using {}", (Object)SimpleItemCollectionFactory.class.getName());
            this.collectionFactory = new SimpleItemCollectionFactory();
        }
        if (this.selectionStrategy == null) {
            throw new ComponentInitializationException(this.getId() + " selection strategy is null");
        }
        if (this.selectedItemPipeline == null && this.nonselectedItemPipeline == null) {
            throw new ComponentInitializationException(this.getId() + " selected and non-selected pipelines are null");
        }
        if (this.selectedItemPipeline != null && !this.selectedItemPipeline.isInitialized()) {
            this.log.debug("Selected item pipeline was not initialized, initializing it now.");
            this.selectedItemPipeline.initialize();
        }
        if (this.nonselectedItemPipeline != null && !this.nonselectedItemPipeline.isInitialized()) {
            this.log.debug("Non-selected item pipeline was not initialized, initializing it now.");
            this.nonselectedItemPipeline.initialize();
        }
        if (this.mergeStrategy == null) {
            this.log.debug("No collection merge strategy specified, using {}", (Object)SimpleCollectionMergeStrategy.class.getName());
            this.mergeStrategy = new SimpleCollectionMergeStrategy();
        }
    }
}

