/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.jcip.annotations.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.ComponentInitializationException;
import net.shibboleth.metadata.pipeline.StageProcessingException;

@ThreadSafe
public class StaticItemSourceStage<ItemType extends Item<?>>
extends BaseStage<ItemType> {
    private Collection<ItemType> source;

    public Collection<ItemType> getSourceItems() {
        return this.source;
    }

    public synchronized void setSourceItems(Collection<ItemType> items) {
        if (this.isInitialized()) {
            return;
        }
        if (items == null || items.isEmpty()) {
            this.source = Collections.emptyList();
            return;
        }
        this.source = new ArrayList<ItemType>();
        for (Item item : items) {
            if (item == null) continue;
            this.source.add(item);
        }
    }

    @Override
    protected void doExecute(Collection<ItemType> itemCollection) throws StageProcessingException {
        for (Item items : this.getSourceItems()) {
            if (items == null) continue;
            itemCollection.add(items.copy());
        }
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.source == null || this.source.isEmpty()) {
            this.source = Collections.emptyList();
        }
    }
}

